# 2017/08/24

## Typescript 

* 枚举类型

```typescript
enum Color { Red, Green, Yellow }
let c: Color = Color.Green
```

默认从零开始赋值，也可手动赋值，并可通过枚举值获取它的名字。

```typescript
let colorName: string = Color[2] // Yellow
```

* 类型断言

通过*类型断言*告诉编译器，“我知道自己在干嘛”，类似于其他语言的类型强制转化。

```typescript
// 类型断言的两种写法
// "尖括号"
let someValue: any = "this is a string"
let strLength: number = (<string>someValue).length
// "as"，在jsx中禁用了“尖括号”的方式
let strLength: number = (someValue as string).length
```

* 接口（interface）


只要传入的对象满足接口提到的必要条件，那么它就是被允许的。
```typescript
interface LabelledValue {
  label: string
}

function printLabel(labelledObj: LabelledValue) {
  console.log(labelledObj.label)
}

let myObj = {size: 10, label: "Size 10 Object"}
printLabel(myObj)
```

可选属性，在可选属性名字后面加一个 *？* 符号，可选属性的好处之一是可以对可能存在的属性进行预定义，好处之二是可以捕获引用了不存在的属性时的错误。
```typescript
interface SquareConfig {
  color?: string
  width?: number
}

function createSquare(config: SquareConfig): { color: string; area: number } {
  let newSquare = {color: "white", area: 100}
  if (config.color) {
    // Error: Property 'clor' does not exist on type 'SquareConfig'
    newSquare.color = config.clor
  }
  if (config.width) {
    newSquare.area = config.width * config.width
  }
  return newSquare;
}

let mySquare = createSquare({color: "black"})
```

只读属性，在属性名前加上 `readonly`
```typescript
interface Point {
  readOnly x: number
  readOnly y: number
}

let p: Point = { x: 1, y: 2 }
p.x = 2 // Error!
```
Tip: 需要不可变的量时候，作为变量用 `const`，作为属性用 `readonly`

额外属性检查，即如果一个对象字面量存在任何“目标类型”不包含的属性时，你会得到一个错误。
```typescript
interface SquareConfig {
    color?: string
    width?: number
}

function createSquare(config: SquareConfig): { color: string; area: number } {
    // ...
}

// error: 'colour' not expected in type 'SquareConfig'
let mySquare = createSquare({ colour: "red", width: 100 })

// 使用类型断言绕开检查
let mySquare = createSquare({ width: 100, opacity: 0.5 } as SquareConfig)

// 添加字符串索引签名，表示可以带有任意数量的其他属性
interface SquareConfig {
    color?: string;
    width?: number;
    [propName: string]: any;
}
```

实现接口，与C#和Java的接口的基本作用一样
```typescript
interface ClockInterface {
    currentTime: Date
    setTime(d: Date)
}

class Clock implements ClockInterface {
    currentTime: Date;
    setTime(d: Date) {
        this.currentTime = d
    }
    constructor(h: number, m: number) { }
}
```
接口可以互相继承，并可继承多接口
```typescript
interface Shape {
    color: string;
}

interface PenStroke {
    penWidth: number;
}

interface Square extends Shape, PenStroke {
    sideLength: number;
}
```

## Redux-form

* 首先需要将 `formReducer` 和自己其他的reducer合并在一起。
``` javascript
import { createStore, combineReducers } from 'redux'
import { reducer as formReducer } from 'redux-form'

const rootReducer = combineReducers({
  // ...your other reducers here
  // you have to pass formReducer under 'form' key,
  // for custom keys look up the docs for 'getFormState'
  form: formReducer
})

const store = createStore(rootReducer)
```

* 创建form的组件

`Field` 是一个具有 `input` 基本的types的一个组件

`reduxForm` 使用其与包裹form组件与 `store` 进行交流，并提供了form状态的 `props` 和处理 `submit` 的函数 
```javascript
import React from 'react'
import { Field, reduxForm } from 'redux-form'

let ContactForm = props => {
  const { handleSubmit } = props
  return (
    <form onSubmit={ handleSubmit }>
      <div>
        <label htmlFor="firstName">First Name</label>
        <Field name="firstName" component="input" type="text" />
      </div>
      <div>
        <label htmlFor="lastName">Last Name</label>
        <Field name="lastName" component="input" type="text" />
      </div>
      <button type="submit">Submit</button>
    </form>
  )
}

ContactForm = reduxForm({
  // a unique name for the form
  form: 'contact'
})(ContactForm)

export default ContactForm;
```

* 创建submit方法

```javascript
import React from 'react'
import ContactForm from './ContactForm'

class ContactPage extends React.Component {
  submit = (values) => {
    // print the form values to the console
    console.log(values)
  }
  render() {
    return (
      <ContactForm onSubmit={this.submit} />
    )
  }
}
```
