export async function generateChatCompletions(prompt, executeTimes, params) {
  const headers = {
    "Content-Type": "application/json",
    Authorization: `Bearer ${process.env.API_KEY}`, // Replace with your OpenAI API key
  };

  const endpoint =
    "https://api.openai.com/v1/chat/completions?api-version=2024-02-01";

  const defaultConfig = {
    model: "gpt-3.5-turbo-0613",
    max_tokens: 1200,
    temperature: 0.9,
    top_p: 1.0,
    n: 1,
  };

  function fetchWithTimeout(url, options = {}, timeout = 60) {
    // 创建一个定时 Promise，模拟超时
    const timeoutPromise = new Promise((_, reject) =>
      setTimeout(() => reject(new Error("Request timed out")), timeout * 1000)
    );

    // 使用 Promise.race 来并行处理 fetch 和 timeout
    return Promise.race([fetch(url, options), timeoutPromise]);
  }

  const sendRequest = async () => {
    const payload = {
      messages: [{ role: "user", content: prompt }],
      ...defaultConfig,
      ...params,
    };

    try {
      const response = await fetchWithTimeout(endpoint, {
        method: "POST",
        headers,
        body: JSON.stringify(payload),
      });
      const data = await response.json();
      return data.choices[0]?.message?.content || ""; // 处理可能的错误
    } catch (error) {
      console.error("Error fetching completion:", error);
      return ""; // 处理网络错误或其他异常
    }
  };

  const requests = Array.from({ length: executeTimes }, sendRequest);

  const newValues = await Promise.all(requests);

  return newValues;
}
