// checkIsThisLocale.ts
import * as OpenCC from 'opencc-js';

type Locale = "zh" | "zh-hant" | "en";

function isEnglishOnly(text: string): boolean {
  return /^[a-zA-Z\s.,!?'"()]+$/.test(text);
}

/**
 * 检查文本是否完全属于指定语言
 * @param text 输入文本
 * @param locale "zh" | "zh-hant" | "en"
 * @returns boolean
 */
export default async function checkIsThisLocale(text: string, locale: Locale, debug?: Boolean): Promise<boolean | any> {

  const converter1 = OpenCC.Converter({ from: 'hk', to: 'cn' });
  const converter2 = OpenCC.Converter({ from: 'cn', to: 'hk' });
  const simplified = converter1(text)
  const traditional = converter2(text);

  switch (locale) {
    case "zh":

      if (debug) {
        return {
          result: text === simplified && !/[a-zA-Z]/.test(text),
          convert: simplified
        }
      }
      return text === simplified && !/[a-zA-Z]/.test(text);

    case "zh-hant":
      if (debug) {
        return {
          result: text === traditional && text !== simplified && !/[a-zA-Z]/.test(text),
          convert: traditional
        }
      }
      return text === traditional && text !== simplified && !/[a-zA-Z]/.test(text);

    case "en":
      return isEnglishOnly(text);

    default:
      throw new Error(`Unsupported locale: ${locale}`);
  }
}