
// 去除 HTML 标签的函数
function stripHtml(html) {
    return html.replace(/<[^>]*>/g, '').trim();
}

export function extractTextFields(jsonString) {
    const targetKeys = new Set([
        'text1', 'text2', 'text3',
        'button', 'button1', 'formButtonText',
        'sectionName', 'sectionDescription'
    ]);

    const result = [];

    // 解析 JSON 字符串
    let json;
    try {
        json = JSON.parse(jsonString);
    } catch (err) {
        console.error('Invalid JSON:', err);
        return result;
    }

    // 遍历对象，递归查找目标字段
    function traverse(obj) {
        if (typeof obj !== 'object' || obj === null) return;

        for (const key in obj) {
            const value = obj[key];

            if (targetKeys.has(key) && typeof value === 'string') {
                result.push(stripHtml(value));
            }

            if (typeof value === 'object') {
                traverse(value);
            }
        }
    }
    traverse(json);
    return result;
}
