import { readFileSync, writeFileSync, existsSync, mkdirSync } from 'fs';
import { dirname } from 'path';

async function main() {
  const readPath = 'src/tasks/checki18n/data/prompts.json';

  if (!existsSync(readPath)) {
    console.error(`File not found: ${readPath}`);
    return;
  }

  const templates = JSON.parse(readFileSync(readPath, 'utf-8'));
  console.log('templates', templates);

  templates.forEach((item: { name: string }) => {
    const targetPath = `src/tasks/checki18n/data/tw/${item.name}.json`;
    const targetDir = dirname(targetPath);

    // 确保目录存在
    if (!existsSync(targetDir)) {
      mkdirSync(targetDir, { recursive: true });
    }

    // 写入空数组
    writeFileSync(targetPath, JSON.stringify([], null, 2), 'utf8');
    console.log(`Generated: ${targetPath}`);
  });
}

main().catch(console.error);