
export async function fetchAzureOpenAIResponse(prompt: string): Promise<string> {
  const endpoint = "https://strikingly-main-us-east.openai.azure.com/openai/deployments/gpt-4o-mini-20240718/chat/completions?api-version=2024-02-01";
  const apiKey = "0f7c45a9023c4eac93f1547cbc75bd53";

  const payload = {
    messages: [
      { role: "user", content: prompt }
    ],
    max_tokens: 4000,
    temperature: 0.7,
    top_p: 1,
    response_format: { type: "json_object" }, // ✅ 用对象
    presence_penalty: 0,
    frequency_penalty: 0
  };

  try {
    const response = await fetch(endpoint, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "api-key": apiKey
      },
      body: JSON.stringify(payload)
    });

    const text = await response.text(); // 先用 text 调试
    if (!response.ok) {
      console.error("Fetch error:", response.status, text);
      return "";
    }

    const json = JSON.parse(text);
    const content = json?.choices?.[0]?.message?.content ?? "";

    // 替换所有 <span(?!>) 为 <span>
    return content.replace(/<span(?!>)/g, "<span>");
  } catch (error) {
    console.error("Exception in fetchAzureOpenAIResponse:", error);
    return "";
  }
}