import { sendSlackFile } from '../clients/slack';
import { readdirSync } from 'fs';
import { join } from 'path';

async function uploadAll() {
  const useAiSelectors = process.env.USE_AI_SELECTORS === 'true';
  const token = process.env.SLACK_BOT_USER_OAUTH_TOKEN!;
  const channel = process.env.DESIGN_TEAM_CHANNEL_ID!;
  const dir = join(__dirname, useAiSelectors ? 'diffAIWithBaseline' : 'diffWithBaseline');
  const files = readdirSync(dir).filter(f => f.endsWith('.json'));

  for (const file of files) {
    const filePath = join(dir, file);
    console.log(`上传 ${file} 到 Slack…`);
    await sendSlackFile(token, channel, filePath, `Diff 文件：${file}`);
  }
}

uploadAll().catch(err => {
  console.error(err);
  process.exit(1);
});
