import { spawn } from "bun";

// 任务执行入口，自动设置 SLACK_WEBHOOK 并依次运行 gsheet、gsheet:ai 和 notify-slack
async function main() {
  const env = {
    ...process.env
  };

  // 运行 bun run task:gsheet
  await spawn({
    cmd: ["bun", "run", "task:gsheet"],
    env,
    stdout: "inherit",
    stderr: "inherit"
  });

  // 延迟执行 task:gsheet:ai 避免 Google Sheet 限流
  const delayMs = parseInt(process.env.GSHEET_AI_DELAY_MS ?? "60000", 10);
  console.log(`Waiting ${delayMs}ms before running task:gsheet:ai to avoid rate limiting`);
  await new Promise<void>(resolve => setTimeout(resolve, delayMs));

  // 运行 bun run task:gsheet:ai
  await spawn({
    cmd: ["bun", "run", "task:gsheet:ai"],
    env,
    stdout: "inherit",
    stderr: "inherit"
  });

  // 运行 bun run notify-slack
  await spawn({
    cmd: ["bun", "run", "notify-slack"],
    env,
    stdout: "inherit",
    stderr: "inherit"
  });
}

// 调用入口
main().catch(err => {
  console.error(err);
  process.exit(1);
});