import { sendSlackMessage } from '../clients/slack';

async function main() {
  const webhookUrl = process.env.SLACK_WEBHOOK!;
  const nonAiUrl = `https://docs.google.com/spreadsheets/d/${process.env.GOOGLE_SHEET_ID}/edit`;
  const aiUrl = `https://docs.google.com/docs.google.com/spreadsheets/d/${process.env.GOOGLE_SHEET_AI_ID}/edit`;
  await sendSlackMessage(webhookUrl, {
    issue: 'Inconsistencies are detected in i18n master section template',
    details: `Google Sheet Links:\n- Non-AI selectors: ${nonAiUrl}\n- AI selectors: ${aiUrl}`
  });
}

main().catch(err => {
  console.error(err);
  process.exit(1);
});
