import { sendSlackFile } from '../clients/slack';
import { readdirSync } from 'fs';
import { join } from 'path';

async function uploadAll() {
  const token = process.env.SLACK_TOKEN!;
  const channel = process.env.SLACK_CHANNEL!;
  const dir = join(__dirname, 'diffWithBaseline');
  const files = readdirSync(dir).filter(f => f.endsWith('.json'));

  for (const file of files) {
    const filePath = join(dir, file);
    console.log(`上传 ${file} 到 Slack…`);
    await sendSlackFile(token, channel, filePath, `Diff 文件：${file}`);
  }
}

uploadAll().catch(err => {
  console.error(err);
  process.exit(1);
});
