// @ts-nocheck
import { diff } from 'deep-diff';
import { readFileSync, writeFileSync, mkdirSync, rmSync, readdirSync } from 'fs';
import { join } from 'path';
import { section_selectors, sectionSelectorLanguages, ai_section_selectors, aiSectionSelectorsLanguages, diffBaselineId } from '../constant/section_selectors';

const useAiSelectors = process.env.USE_AI_SELECTORS === 'true';

// Directory containing navigation JSON outputs to compare
const srcDir = 'src/detect_section_selector_masters/extractNavOutput';
// Directory to write nav diff results
const outDir = useAiSelectors ? 'src/detect_section_selector_masters/diffAINavWithBaseline' : 'src/detect_section_selector_masters/diffNavWithBaseline';

// Remove existing output folder if it exists
rmSync(outDir, { recursive: true, force: true });
// Ensure output directory exists
mkdirSync(outDir, { recursive: true });

const selectedLanguages = useAiSelectors ? aiSectionSelectorsLanguages : sectionSelectorLanguages;

// Baseline nav file
const baselineFile = `${diffBaselineId}_extractNav.json`;
const baselinePath = join(srcDir, baselineFile);
const baselineData = JSON.parse(readFileSync(baselinePath, 'utf-8'));

// Get all nav files excluding baseline
const allFiles = readdirSync(srcDir).filter(f => f.endsWith('_extractNav.json') && f !== baselineFile);

allFiles.forEach(file => {
  const otherId = file.split('_')[0];
  const otherPath = join(srcDir, file);
  const otherData = JSON.parse(readFileSync(otherPath, 'utf-8'));

  // Compute differences
  const changes = diff(baselineData, otherData) || [];

  // Write diff output
  const outFile = `${selectedLanguages[diffBaselineId]}_vs_${selectedLanguages[otherId]}_nav_diff.json`;
  const outPath = join(outDir, outFile);
  writeFileSync(outPath, JSON.stringify(changes, null, 2), 'utf-8');
  console.log(`✅ Nav diff between ${diffBaselineId} and ${otherId} written to ${outPath}`);
});
