export async function sendSlackMessage(webhookUrl: string, params: {
  issue: string,
  displayName: string,
  language: string,
  siteEditor: string
}) {
  const text = [
    `Issue: ${params.issue}`,
    `Display Name: ${params.displayName}`,
    `Language: ${params.language}`,
    `Site editor: ${params.siteEditor}`
  ].join('\n');

  const res = await fetch(webhookUrl, {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({ text })
  });

  if (!res.ok) {
    throw new Error(`Slack 推送失败: ${res.status} ${res.statusText}`);
  }
}

// 示例用法
// sendSlackMessage('https://hooks.slack.com/services/T00000000/B00000000/XXXXXXXXXXXXXXXXXXXXXXXX', {
//   issue: 'Theme color missing',
//   displayName: 'Lavender',
//   language: 'en',
//   siteEditor: 'https://www.strikingly.com/s/sites/12572142/edit'
// }); 