* Selector Delimiters

Add a line break after each selector delimiter. Do not add spaces before or after delimiters.

Correct:

```
.nav,
.bar {
  color: @color__base;
}
```

Incorrect:

```
.nav, .bar {
  color: @color__base;
}
```

* Using Single quote.

```
.nav {
  content: 'lorem ipsum';
}
```

* Add spaces before and after combinators.

```
.nav + .bar {
  color: @bar__color;
}
```

* Add a blank line at the end of file.
* Add a blank line after a selector.
* Avoid using the !important property if possible. If it is required, add a space before the property and leave a comment.
* Avoid the id selector.
* All top-level classnames (common elements and feature wrappers) must have s- prefix
* Class names should be lowercase, start with a letter (except helper classes), words should be separated with dash ‘-‘.
* Avoid using more than three levels of nesting.