'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var React = require('react');
var createProxy = require('react-proxy').default;
var global = require('global');

var ComponentMap = function () {
  function ComponentMap(useWeakMap) {
    _classCallCheck(this, ComponentMap);

    if (useWeakMap) {
      this.wm = new WeakMap();
    } else {
      this.slots = {};
    }
  }

  _createClass(ComponentMap, [{
    key: 'getSlot',
    value: function getSlot(type) {
      var key = type.displayName || type.name || 'Unknown';
      if (!this.slots[key]) {
        this.slots[key] = [];
      }
      return this.slots[key];
    }
  }, {
    key: 'get',
    value: function get(type) {
      if (this.wm) {
        return this.wm.get(type);
      }

      var slot = this.getSlot(type);
      for (var i = 0; i < slot.length; i++) {
        if (slot[i].key === type) {
          return slot[i].value;
        }
      }

      return undefined;
    }
  }, {
    key: 'set',
    value: function set(type, value) {
      if (this.wm) {
        this.wm.set(type, value);
      } else {
        var slot = this.getSlot(type);
        for (var i = 0; i < slot.length; i++) {
          if (slot[i].key === type) {
            slot[i].value = value;
            return;
          }
        }
        slot.push({ key: type, value: value });
      }
    }
  }, {
    key: 'has',
    value: function has(type) {
      if (this.wm) {
        return this.wm.has(type);
      }

      var slot = this.getSlot(type);
      for (var i = 0; i < slot.length; i++) {
        if (slot[i].key === type) {
          return true;
        }
      }
      return false;
    }
  }]);

  return ComponentMap;
}();

var proxiesByID = void 0;
var didWarnAboutID = void 0;
var hasCreatedElementsByType = void 0;
var idsByType = void 0;

var hooks = {
  register: function register(type, uniqueLocalName, fileName) {
    if (typeof type !== 'function') {
      return;
    }
    if (!uniqueLocalName || !fileName) {
      return;
    }
    if (typeof uniqueLocalName !== 'string' || typeof fileName !== 'string') {
      return;
    }
    var id = fileName + '#' + uniqueLocalName; // eslint-disable-line prefer-template
    if (!idsByType.has(type) && hasCreatedElementsByType.has(type)) {
      if (!didWarnAboutID[id]) {
        didWarnAboutID[id] = true;
        var baseName = fileName.replace(/^.*[\\\/]/, '');
        console.error('React Hot Loader: ' + uniqueLocalName + ' in ' + fileName + ' will not hot reload ' + ('correctly because ' + baseName + ' uses <' + uniqueLocalName + ' /> during ') + ('module definition. For hot reloading to work, move ' + uniqueLocalName + ' ') + ('into a separate file and import it from ' + baseName + '.'));
      }
      return;
    }

    // Remember the ID.
    idsByType.set(type, id);

    // We use React Proxy to generate classes that behave almost
    // the same way as the original classes but are updatable with
    // new versions without destroying original instances.
    if (!proxiesByID[id]) {
      proxiesByID[id] = createProxy(type);
    } else {
      proxiesByID[id].update(type);
    }
  },
  reset: function reset(useWeakMap) {
    proxiesByID = {};
    didWarnAboutID = {};
    hasCreatedElementsByType = new ComponentMap(useWeakMap);
    idsByType = new ComponentMap(useWeakMap);
  }
};

hooks.reset(typeof WeakMap === 'function');

function resolveType(type) {
  // We only care about composite components
  if (typeof type !== 'function') {
    return type;
  }

  hasCreatedElementsByType.set(type, true);

  // When available, give proxy class to React instead of the real class.
  var id = idsByType.get(type);
  if (!id) {
    return type;
  }

  var proxy = proxiesByID[id];
  if (!proxy) {
    return type;
  }

  return proxy.get();
}

var createElement = React.createElement;
function patchedCreateElement(type) {
  // Trick React into rendering a proxy so that
  // its state is preserved when the class changes.
  // This will update the proxy if it's for a known type.
  var resolvedType = resolveType(type);

  for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }

  return createElement.apply(undefined, [resolvedType].concat(args));
}
patchedCreateElement.isPatchedByReactHotLoader = true;

function patchedCreateFactory(type) {
  // Patch React.createFactory to use patched createElement
  // because the original implementation uses the internal,
  // unpatched ReactElement.createElement
  var factory = patchedCreateElement.bind(null, type);
  factory.type = type;
  return factory;
}
patchedCreateFactory.isPatchedByReactHotLoader = true;

if (typeof global.__REACT_HOT_LOADER__ === 'undefined') {
  React.createElement = patchedCreateElement;
  React.createFactory = patchedCreateFactory;
  global.__REACT_HOT_LOADER__ = hooks;
}