'use strict';

function isRequire(node) {
  return node && node.callee && node.callee.type === 'Identifier' && node.callee.name === 'require' && node.arguments.length >= 1;
}

function isStaticValue(arg) {
  return arg.type === 'Literal' || arg.type === 'TemplateLiteral' && arg.expressions.length === 0;
}

module.exports = {
  meta: {
    docs: {}
  },

  create: function (context) {
    return {
      CallExpression(node) {
        if (isRequire(node) && !isStaticValue(node.arguments[0])) {
          context.report({
            node,
            message: 'Calls to require() should use string literals'
          });
        }
      }
    };
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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