'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAbsolute = isAbsolute;
exports.isBuiltIn = isBuiltIn;
exports.default = resolveImportType;

var _lodash = require('lodash.cond');

var _lodash2 = _interopRequireDefault(_lodash);

var _builtinModules = require('builtin-modules');

var _builtinModules2 = _interopRequireDefault(_builtinModules);

var _path = require('path');

var _resolve = require('eslint-module-utils/resolve');

var _resolve2 = _interopRequireDefault(_resolve);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function constant(value) {
  return () => value;
}

function isAbsolute(name) {
  return name.indexOf('/') === 0;
}

function isBuiltIn(name, settings) {
  const extras = settings && settings['import/core-modules'] || [];
  return _builtinModules2.default.indexOf(name) !== -1 || extras.indexOf(name) > -1;
}

function isExternalPath(path, name, settings) {
  const folders = settings && settings['import/external-module-folders'] || ['node_modules'];
  return !path || folders.some(folder => -1 < path.indexOf((0, _path.join)(folder, name)));
}

const externalModuleRegExp = /^\w/;
function isExternalModule(name, settings, path) {
  return externalModuleRegExp.test(name) && isExternalPath(path, name, settings);
}

const scopedRegExp = /^@\w+\/\w+/;
function isScoped(name) {
  return scopedRegExp.test(name);
}

function isInternalModule(name, settings, path) {
  return externalModuleRegExp.test(name) && !isExternalPath(path, name, settings);
}

function isRelativeToParent(name) {
  return name.indexOf('../') === 0;
}

const indexFiles = ['.', './', './index', './index.js'];
function isIndex(name) {
  return indexFiles.indexOf(name) !== -1;
}

function isRelativeToSibling(name) {
  return name.indexOf('./') === 0;
}

const typeTest = (0, _lodash2.default)([[isAbsolute, constant('absolute')], [isBuiltIn, constant('builtin')], [isExternalModule, constant('external')], [isScoped, constant('external')], [isInternalModule, constant('internal')], [isRelativeToParent, constant('parent')], [isIndex, constant('index')], [isRelativeToSibling, constant('sibling')], [constant(true), constant('unknown')]]);

function resolveImportType(name, context) {
  return typeTest(name, context.settings, (0, _resolve2.default)(name, context));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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