class SoundManager {
    private static instance: SoundManager;
    private sounds: any
    public constructor() {
        this.init()
    }

    private init() {
        this.sounds = {}
        const soundNames = [
            'catched_0_mp3',
            'catched_1_mp3',
            'catched_2_mp3',
            'flirt_mp3',
            'bgm_mp3',
        ]
        soundNames.forEach(soundName => {
            this.sounds[soundName] = RES.getRes(soundName)
        })
    }
    // 实例化单例获取方法
    public static getInstance(): SoundManager {
        if (!SoundManager.instance) {
            SoundManager.instance = new SoundManager();
        }
        return SoundManager.instance;
    }

    public play({soundName, startTime = 0, loops = 1}) {
        this.sounds[soundName].play(startTime, loops)
    }
    // 随机播放被抓音频
    public playCatched(num?) {
        const soundName = [
            'catched_0_mp3',
            'catched_2_mp3',
        ][num || this.rnd(0, 1)]
        this.play({soundName})
    }

    rnd(start, end) {
        return Math.floor(Math.random() * (end - start) + start)
    }
}