//////////////////////////////////////////////////////////////////////////////////////
//
//  Copyright (c) 2014-present, Egret Technology.
//  All rights reserved.
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of the Egret nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY EGRET AND CONTRIBUTORS "AS IS" AND ANY EXPRESS
//  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
//  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
//  IN NO EVENT SHALL EGRET AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
//  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE, DATA,
//  OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//////////////////////////////////////////////////////////////////////////////////////

class Main extends egret.DisplayObjectContainer {

    public constructor() {
        super();
        this.addEventListener(egret.Event.ADDED_TO_STAGE, this.onAddToStage, this);

    }

    private onAddToStage(event: egret.Event) {

        egret.lifecycle.addLifecycleListener((context) => {
            // custom lifecycle plugin

            context.onUpdate = () => {

            }
        })

        egret.lifecycle.onPause = () => {
            egret.ticker.pause();
        }

        egret.lifecycle.onResume = () => {
            egret.ticker.resume();
        }

        this.runGame().catch(e => {
            console.log(e);
        })
    }

    private async runGame() {
        await this.loadResource()
        var stage = egret.MainContext.instance.stage;
        stage.setContentSize(1334, 750);
        await platform.login();
        const userInfo = await platform.getUserInfo();
        Store.onMessage({
            type: 'setUserInfo',
            payload: userInfo
        })
        console.log(userInfo);

        SoundManager.getInstance().play({soundName: "bgm_mp3", startTime: 0, loops: -1})
        platform.onShareAppMessage((...args) => {
            return {
                title: "你已经被盯上了 ~",
                imageUrl: "https://ws4.sinaimg.cn/large/006tKfTcgy1fr1hg7dg9oj30nc0iota0.jpg"
            }
        })
        platform.showShareMenu({
            withShareTicket: false
        })
        platform.connectSocket({
            url: "ws://192.168.50.118:9090",
            header: {
                'content-type': 'application/json'
            },
            method: "GET",
            success: (...args) => {
                console.error("connectSocket success")
                console.error(args)
            },
            fail: (...args) => {
                console.error("connectSocket fail")
                console.error(args)
            }
        })

        platform.onSocketOpen(() => {
            platform.sendSocketMessage({
                data: JSON.stringify({
                    type: 'entry',
                    room_id: 'default_room',
                    payload: {
                        avatar_url: Store.getState().userInfo.avatarUrl,
                        nick_name: Store.getState().userInfo.nickName
                    }
                }),
                success: res => {
                    console.error("sendSocketMessage success")
                },
                fail: res => {
                    console.error("sendSocketMessage fail")
                },
                complete: res => {

                }
            })
        })
        this.createGameScene();
        platform.onSocketMessage(function(res) {
            console.log('收到服务器内容：' + res.data)
            let data = res.data
            if (typeof res.data === 'string') {
                data = JSON.parse(res.data)
            }
            // data = { "type": "game_ready", "rid": "default_room", "payload": [{ "nick_name": "syfee", "avatar_url": "https://wx.qlogo.cn/mmopen/vi_32/Q0j4TwGTfTIibqBbRLAe0AI9NvnzPdLEBx9mT0ZKXicbibYWLAJiaPs0EZtmDiazJ7kytEj4tzWiberUptkR1yg0Q28g/132", "cid": "1525524303u0my3", "role": "ghost", "t_cid": "1525524303u0my3", x: 1, y: 1 }, { "nick_name": "syfee1", "avatar_url": "https://wx.qlogo.cn/mmopen/vi_32/Q0j4TwGTfTIibqBbRLAe0AI9NvnzPdLEBx9mT0ZKXicbibYWLAJiaPs0EZtmDiazJ7kytEj4tzWiberUptkR1yg0Q28g/132", "cid": "1525524303u0my4", "role": "runner", "t_cid": "1525524303u0my4", x: 1, y: 1 }], "cid": "1525524303u0my4" }
            const state = Store.onMessage(data)
            EventBus.dispatch(data.type, data)
            switch (data.type) {
                case 'entry':
                    Store.onMessage({
                        type: 'updateCid',
                        payload: data
                    })
                    SceneManager.getInstance().roomScene.update(data)
                    break;
                case 'game_ready':
                    SceneManager.getInstance().roomScene.update(data)
                    break;
                case 'game_end':
                    SceneManager.getInstance().changeScene('gameoverScene')
                    SceneManager.getInstance().gameoverScene.update(data)
                    break;
            }
        })
        platform.onSocketError((e) => {
            console.error("onSocketError")
            console.error(e)
        })

        platform.onSocketClose((e) => {
            console.error("onSocketClose")
            console.error(e)
        })
    }

    private async loadResource() {
        try {
            const loadingView = new LoadingUI();
            this.stage.addChild(loadingView);
            await RES.loadConfig("resource/default.res.json", "resource/");
            await RES.loadGroup("preload", 0, loadingView);
            this.stage.removeChild(loadingView);
        }
        catch (e) {
            console.error(e);
        }
    }

    private textfield: egret.TextField;
    private myPosition = new egret.Point(0, 0)

    /**
     * 创建游戏场景
     * Create a game scene
     */
    private createGameScene() {
        this.addChild(SceneManager.getInstance());
        // SoundManager.getInstance().play({soundName: 'bgm_mp3', loops: -1})
        // SoundManager.getInstance().playCatched(1)
    }

    /**
     * 根据name关键字创建一个Bitmap对象。name属性请参考resources/resource.json配置文件的内容。
     * Create a Bitmap object according to name keyword.As for the property of name please refer to the configuration file of resources/resource.json.
     */
    private createBitmapByName(name: string) {
        let result = new egret.Bitmap();
        let texture: egret.Texture = RES.getRes(name);
        result.texture = texture;
        return result;
    }

}
