class Guy extends egret.Sprite {

  public constructor() {
    super()
    this.init()
  }

  private avatar = new egret.Bitmap()
  private imageLoader = new egret.ImageLoader()

  private init() {
    this.avatar.width = 72
    this.avatar.height = 72
    this.imageLoader.addEventListener(egret.Event.COMPLETE,this.loadCompleteHandler,this)
    this.imageLoader.load("http://www.insajderi.com/wp-content/uploads/2018/01/asdja.jpg")
    this.addChild(this.avatar)
  }

  private loadCompleteHandler() {
    let texture = new egret.Texture()
    texture._setBitmapData(this.imageLoader.data)
    this.avatar.texture = texture
  }
  private step = 72
  public applyDelta(delta){
    this.x += this.step * delta.x
    this.y += this.step * delta.y
    
    if(this.x <= 10){
        this.x = 10
    }
    if(this.y <= 15){
        this.y = 15
    }
    if(this.y >= 72*9 + 15){
        this.y = 72*9 + 15
    }
    if(this.x >= 72*13 + 10){
        this.x = 72*13 + 10
    }
  }
}