class Controller extends egret.Sprite {
    public constructor() {
        super();
        this.init()
    }
 
    private control = new egret.Bitmap()
    private panel = new egret.Shape()

    private up = new egret.Shape()
    private down = new egret.Shape()
    private left = new egret.Shape()
    private right = new egret.Shape()

    // 初始化(给开始按钮绑定点击事件)
    private init() {

        this.panel.graphics.beginFill(0x353E5D, 1)
        this.panel.graphics.drawRect(1008, 0, 326, 750)
        this.panel.graphics.endFill()
        this.addChild(this.panel)
        
        let texture: egret.Texture = RES.getRes("control_jpg")
        this.control.texture = texture

        let controlContainer = new egret.Sprite()
        this.addChild(controlContainer)
        controlContainer.x = 1040
        controlContainer.y = 450
        controlContainer.addChild(this.control)

        this.up.graphics.beginFill(0xFF00FF, 1)
        this.up.graphics.drawRect(93, 0, 80, 80)
        this.up.graphics.endFill()
        this.up.touchEnabled = true
        this.up.alpha = 0
        this.up.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.controlTouchBegin, this)

        this.down.graphics.beginFill(0xFF00FF, 1)
        this.down.graphics.drawRect(93, 186, 80, 80)
        this.down.graphics.endFill()
        this.down.touchEnabled = true
        this.down.alpha = 0
        this.down.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.controlTouchBegin, this)

        this.left.graphics.beginFill(0xFF00FF, 1)
        this.left.graphics.drawRect(0, 93, 80, 80)
        this.left.graphics.endFill()
        this.left.touchEnabled = true
        this.left.alpha = 0
        this.left.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.controlTouchBegin, this)

        this.right.graphics.beginFill(0xFF00FF, 1)
        this.right.graphics.drawRect(186, 93, 80, 80)
        this.right.graphics.endFill()
        this.right.touchEnabled = true
        this.right.alpha = 0
        this.right.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.controlTouchBegin, this)

        controlContainer.addChild(this.up)
        controlContainer.addChild(this.down)
        controlContainer.addChild(this.left)
        controlContainer.addChild(this.right)
    }

    private controlTouchBegin(e: egret.TouchEvent){
        const delta = {x:0, y: 0}
        if(e.currentTarget === this.up){
            delta.y -= 1
        }else if(e.currentTarget === this.down){
            delta.y += 1
        }else if(e.currentTarget === this.left){
            delta.x -= 1
        }else if(e.currentTarget === this.right){
            delta.x += 1
        }
        
        this.dispatchEventWith("position_change", false, delta)
    }

    public release() {
        // 移除事件
    }
}
