
class MapGrid extends egret.Sprite {
  public bg:egret.Bitmap = new egret.Bitmap()
  public constructor() {
    super();
    this.init()
  }

  private init() {
    this.bg.texture = RES.getRes('grid_jpg')
    this.addChild(this.bg)
    this.touchEnabled = true
    if (Store.isCatcher()) {
      this.alpha = 0 
      this.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onTouchTap, this)
    }
  }

  private onTouchTap() {
    if (Store.isCatcher() && !this.parent.isShowingTouchArea) {
      platform.sendSocketMessage({
          data: JSON.stringify({
              type: 'clicking',
              cid: Store.getState().cid, 
              room_id: 'default_room',
              payload: {
                  x: this.x / 72,
                  y: this.y / 72,
                  avatar_url: Store.getMyInfo().avatarUrl,
                  nick_name: Store.getMyInfo().nickName
              }
          }),
      })
    }
  }

  public release() {
  }
}