class Avatar extends egret.Sprite {

  public constructor(userData, showName) {
    super()
    this.init(userData, showName)
  }

  private avatar = new egret.Bitmap()
  private bg = new egret.Bitmap()
  private imageLoader = new egret.ImageLoader()
  private nameLabel = new egret.TextField()


  private init(userData, showName) {
    this.bg.width = 100
    this.bg.height = 100
    this.bg.texture = RES.getRes("avatar_bg_jpg")
    this.addChild(this.bg)

    this.avatar.x = 10
    this.avatar.y = 10
    this.avatar.width = 80
    this.avatar.height = 80
    this.imageLoader.addEventListener(egret.Event.COMPLETE,this.loadCompleteHandler,this)
    this.imageLoader.load(userData.avatar_url || "http://www.insajderi.com/wp-content/uploads/2018/01/asdja.jpg")
    this.addChild(this.avatar)

    if(showName){
        this.nameLabel.text = userData.nick_name
        this.nameLabel.width = 100
        this.nameLabel.textAlign = egret.HorizontalAlign.CENTER;
        this.nameLabel.x = 0
        this.nameLabel.size = 16
        this.nameLabel.y = 100
        this.addChild(this.nameLabel);
    }

  }

  private loadCompleteHandler() {
    let texture = new egret.Texture()
    texture._setBitmapData(this.imageLoader.data)
    this.avatar.texture = texture
  }
}
