class GameoverScene extends egret.Sprite {

    private startLabel: egret.TextField
    private players: Array<any>
    private avatars: any

    public constructor() {
        super();
        this.init()
    }

    // 初始化(给开始按钮绑定点击事件)
    private init() {
        console.log('GameoverScene.init')
        this.initBg()
        this.initEndLabel()
        this.initBackLabel()
    }

    public update(data) {
        const payload = data.payload
        switch (data.type) {
            case 'game_end':

            default:
                break;
        }

    }

    private initBackLabel() {
        var backLabel = new egret.TextField()
        backLabel.text = '< 返回'
        backLabel.x = 50
        backLabel.y = 680
        backLabel.bold = true
        backLabel.touchEnabled = true
        backLabel.addEventListener(egret.TouchEvent.TOUCH_TAP, this.backHandler, this)
        this.addChild(backLabel)
    }

    private backHandler() {
        platform.sendSocketMessage({
            data: JSON.stringify({
                type: 'entry',
                room_id: 'default_room',
                payload: {
                    avatar_url: Store.getState().userInfo.avatarUrl,
                    nick_name: Store.getState().userInfo.nickName
                }
            }),
            success: res => {
                console.error("entry success")
            },
            fail: res => {
                console.error("entry fail")
            },
            complete: res => {

            }
        })
        SceneManager.getInstance().changeScene('roomScene')
    }
    private initCountDown(res) {
        var cdText = new egret.TextField()
        cdText.text = '10'
        const timer = setInterval(() => {
            if (cdText.text == '0') {
                clearInterval(timer)
                SceneManager.getInstance().changeScene('roomScene')
                return
            }
            cdText.text = `${Number(cdText.text) - 1}`
        }, 1000)
    }

    private initBg() {
        var shape: egret.Shape = new egret.Shape();
        shape.graphics.beginFill(0x343E5F);
        shape.graphics.drawRect(0, 0, 2000, 2000);
        shape.graphics.endFill();
        this.addChild(shape);
        // var bg: egret.Bitmap = new egret.Bitmap()
        // bg.texture = RES.getRes("logo_jpg")
        // bg.scaleX = bg.scaleY = 2
        // bg.x = 1334 / 2 - 280
        // bg.y = 100
        // this.addChild(bg)
    }
    private initEndLabel() {
        var gameoverText = new egret.TextField()
        gameoverText.textColor = 0xF0D66D
        gameoverText.strokeColor = 0xffff00
        gameoverText.stroke = 5
        gameoverText.text = "GAME OVER"
        gameoverText.size = 100
        gameoverText.width = 700
        gameoverText.anchorOffsetX = 350
        gameoverText.x = 1334 / 2
        gameoverText.textAlign = egret.HorizontalAlign.CENTER;
        gameoverText.y = 100
        this.addChild(gameoverText);
    }

    public release() {
        // 移除事件

    }
}
