class SceneManager extends egret.DisplayObjectContainer {
  // 场景控制器的单例
  private static instance: SceneManager;
  // 开始场景
  public roomScene: RoomScene;
  // 游戏场景
  public gameScene: GameScene;
  // 游戏结束场景
  public gameoverScene: GameoverScene;
  private sceneMap: any = {
    roomScene: RoomScene,
    gameScene: GameScene,
    gameoverScene: GameoverScene
  }

  public constructor() {
    super();
    this.init();
  }
  private init() {
    // 实例化两个场景
    this.roomScene = new RoomScene();
    this.gameoverScene = new GameoverScene();
    // this.gameScene = new GameScene();
    // 默认添加开始场景
    // this.addChild(this.gameoverScene);
    this.addChild(this.roomScene);
  }
  // 实例化单例获取方法
  public static getInstance(): SceneManager {
    if (!SceneManager.instance) {
      SceneManager.instance = new SceneManager();
    }
    return SceneManager.instance;
  }
  // 切换场景
  public changeScene(type) {
    if (!this[type]) {
      const Scene = this.sceneMap[type]
      this[type] = new Scene ()
    }
    
    // 移除所有显示列表中的对象
    this.removeChildren();
    // 添加下一个场景
    this.addChild(this[type]);
  }
}