class Controller extends egret.Sprite {
    public constructor() {
        super();
        this.init()
    }
 
    private speed = 10
    private speedX = 0
    private speedY = 0
    private p1:egret.Point = new egret.Point();
    private p2:egret.Point = new egret.Point();
    private control = new egret.Shape();
    private pointtt = new egret.Shape();
    private controlCenter = new egret.Point(1100, 450)

  // 初始化(给开始按钮绑定点击事件)
    private init() {
        this.control.graphics.beginFill( 0xFF3866, 1);
        this.control.graphics.drawCircle(1100, 450, 90);
        this.control.graphics.endFill();
        this.addChild( this.control );

        this.pointtt.graphics.beginFill(0xFF0000, 1)
        this.pointtt.graphics.drawCircle(1100, 450, 10)
        this.pointtt.graphics.endFill()
        this.addChild(this.pointtt)

        this.touchEnabled = true
        this.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.controlTouchBegin, this)
        this.addEventListener(egret.TouchEvent.TOUCH_MOVE, this.controlTouchMove, this)
        this.addEventListener(egret.TouchEvent.TOUCH_END, this.controlTouchEnd, this)
        this.addEventListener(egret.Event.ENTER_FRAME,this.onEnterFrame,this)
    }

    private onEnterFrame(e: egret.Event){
        if(this.touchEnd){
            return
        }
        this.pointtt.x += this.speedX
        this.pointtt.y += this.speedY
    }

    private touchEnd = false
    private controlTouchBegin(e: egret.TouchEvent){
        this.touchEnd = false
    }

    private controlTouchMove(e: egret.TouchEvent){
        var angle = Math.atan2(e.stageY - this.controlCenter.y, e.stageX - this.controlCenter.x )
        // console.error(e)
        this.speedX = Math.cos(angle)*this.speed;
        this.speedY = Math.sin(angle)*this.speed;
        // console.error(this.speedX)
        // console.error(e.stageX)
    }

    private controlTouchEnd(e: egret.TouchEvent){
        this.touchEnd = true
        // this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }

    public release() {
        // 移除事件
    }
}