require 'faye/websocket'
require 'rack'
require 'thin'
require 'json'

module CrazyFlirt

  class RandomKeyGenerator
    WORDS = %w(a b c d e f g h i j k l m n o p q r s t u v w x y z 1 2 3 4 5 6 7 8 9 0)
    SIZE = WORDS.size
    def self.key
      words = ::CrazyFlirt::RandomKeyGenerator::WORDS
      size = ::CrazyFlirt::RandomKeyGenerator::SIZE - 1
      random_key = ''
      random = Random.new
      5.times do
        random_key += words[random.rand(0..size)]
      end
      Time.now.to_s.to_i + random_key
    end
  end


  class RandomPicker

    def initialize(clients)
      @client = clients
      @x_max = 14
      @y_max = 10
      @rd = Random.new
    end

    def pick_ghost_index
      size = @client.size - 1
      @rd.rand(0..size)
    end

    def pick_born_point
      x = @rd.rand(0..@x_max)
      y = @rd.rand(0..@y_max)
      [x, y]
    end
  end

  class Client

    attr_reader :key
    attr_accessor :role, :room

    def initialize(ws)
      @ws = ws
      @key = generate_key
      @role = nil
    end

    def msg(msg)
      @ws.send(msg.to_json)
    end
    private

    def generate_key
      CrazyFlirt::RandomKeyGenerator.key
    end
  end


  class GameRoom

    attr_reader :clients

    def initialize(name)
      @clients = []
      @name = name
      @status = :waiting
    end

    def set_client(client)
      @clients << client
      client.size - 1
    end

    def start!
      @status = :start
    end

    def leave_client(key)
      idx = @clients.find_index { |c| c.key == key}
      @clients.delete_at(idx)
    end

  end

  class SocketEngine

    def initialize
      Faye::WebSocket.load_adapter('thin')
      @default_room = "default_room"
      @faye = Faye::WebSocket
      @socket_pool = {}
      @room_pool = {}
      @room_pool[@default_room] = GameRoom.new(@default_room)
    end


    def call(env)
      return unless @faye.websocket?(env)
      ws = @faye.new(env)

      client = ::CrazyFlirt::Client.new(ws)
      @socket_pool[client.key] = client
      ws.on :message do |event|
        message = JSON.parse(event.data)
        seq = message[:type]
        command(seq, message, client)
      end

      ws.on :close do |event|
        @socket_pool.delete(client.key)
        client.room.leave_client(client.key)
        client = nil
        puts 'closed'
      end
      ws.rack_response
    end

    private

    def commend(command, *args)
      send(command, *args)
    end

    def start(msg)
      room = @room_pool[msg['room_id']]
      picker = RandomPicker.new(room.clients)
      idx = picker.pick_ghost_index
      ghost = room.clients[idx]
    end

    def clicking(msg)
      room = @room_pool[msg['room_id']]
      room.clients.each do |client|
        client.msg(msg)
      end
    end

    def moving(msg)
      room = @room_pool[msg['room_id']]
      room.clients.each do |client|
        client.msg(msg)
      end
    end

    def entry(msg, client)
      room = @room_pool[msg['room_id']]
      seat_index = room.set_client(client)
      client.room = room
      msg['cid'] = client.key
      msg['payload']['seat'] = seat_index
      room.clients.each do |client|
        client.msg(msg)
      end
    end

    def create_room(msg)
      client_id = msg['cid']
      key = "room_#{::CrazyFlirt::RandomKeyGenerator.key}"
      room = GameRoom.new(key)
      @room_pool[key] = room
      client = @socket_pool[client_id]
      room.set_client(client)
      client.msg(room_id: key)
    end
  end
end

Rack::Handler.get('thin').run(CrazyFlirt::SocketEngine.new, Host: '192.168.50.118', Port: 9090)