class Rank extends egret.Sprite {

  public constructor(userData) {
    super()
    this.init(userData)
  }

  private avatar = new egret.Bitmap()
  private bg = new egret.Bitmap()
  private imageLoader = new egret.ImageLoader()

  private init(userData) {
    this.bg.width = 100
    this.bg.height = 100
    this.bg.texture = RES.getRes("avatar_bg_jpg")
    this.addChild(this.bg)

    this.avatar.x = 10
    this.avatar.y = 10
    this.avatar.width = 80
    this.avatar.height = 80
    this.imageLoader.addEventListener(egret.Event.COMPLETE,this.loadCompleteHandler,this)
    this.imageLoader.load(userData.avatar_url || "http://www.insajderi.com/wp-content/uploads/2018/01/asdja.jpg")
    this.addChild(this.avatar)

  }

  private loadCompleteHandler() {
    let texture = new egret.Texture()
    texture._setBitmapData(this.imageLoader.data)
    this.avatar.texture = texture
  }
}
