const gridWidth = 72
const gridHeight = 72
const gridsInX = 14
const gridsInY = 10
class Map extends egret.Sprite {
  private grids:any = []
  private touchArea: egret.Bitmap 
  public isShowingTouchArea
  private runnerMap:any = {} 
  public constructor() {
    super();
    this.init()
  }

  // 初始化(给开始按钮绑定点击事件)
  private init() {
    for (let i = 0; i < gridsInY; i++) {
      this.grids.push([])
      for (let j = 0; j < gridsInX; j++) {
        const grid = new MapGrid()
        grid.x = j * gridWidth
        grid.y = i * gridHeight
        this.grids[i].push(grid)
        this.addChild(grid)
      }
    }
    
    this.touchArea = new egret.Bitmap()
    this.touchArea.texture = RES.getRes('mask_jpg')
    this.touchArea.alpha = 0
    this.addChild(this.touchArea)
    Store.getState().runners.forEach(runnerData => {
      const runner = new Runner(runnerData)
      this.addChild(runner)
      this.runnerMap[runnerData.t_cid] = runner
    })
    EventBus.addEventListener('moving', (payload) => {
      this.runnerMap[payload.target.payload.t_cid].x = payload.target.payload.x * gridWidth
      this.runnerMap[payload.target.payload.t_cid].y = payload.target.payload.y * gridHeight
    })
    EventBus.addEventListener('clicking', (payload) => {
      const x = payload.target.payload.x * gridWidth
      const y = payload.target.payload.y * gridHeight
      if (Store.isCatcher()) {
        this.showSurroundedGrids(x, y) 
      } else {
        this.showClickedGrid(x, y)
      }
    })
  }

  public getSurroundedGrids(x, y) {
    const left = x / gridWidth - 2
    const top = y / gridHeight - 2
    const grids = []
    for (let i = left; i < 5 + left; i++) {
      for (let j = top; j < 5 + top; j++) {
        if (i >= 0 && j >= 0 && i < gridsInX && j < gridsInY) {
          grids.push(this.grids[j][i])
        }
      }
    }
    return grids
  }

  public showClickedGrid(x, y) {
    const surroundedGrids = this.getSurroundedGrids(x, y)

    const clickedGrid = surroundedGrids.find(grid => grid.x === x && grid.y === y)
    clickedGrid.bg.texture = RES.getRes('grid_select_jpg')
    setTimeout(() => {
      clickedGrid.bg.texture = RES.getRes('grid_jpg')
    }, 1000); 
  }

  public showSurroundedGrids(x, y) {
    this.isShowingTouchArea = true
    const surroundedGrids = this.getSurroundedGrids(x, y)
    const centerGrid = surroundedGrids.find(grid => grid.x === x && grid.y === y)
    centerGrid.bg.texture = RES.getRes('grid_select_jpg')
    surroundedGrids.forEach(grid => {
      grid.alpha = 1 
    })
    this.touchArea.alpha = 1
    this.touchArea.x = x - 2 * gridWidth
    this.touchArea.y = y - 2 * gridHeight

    setTimeout(() => {
      centerGrid.bg.texture = RES.getRes('grid_jpg')
      surroundedGrids.forEach(grid => {
        grid.alpha = 0
      })
      this.touchArea.alpha = 0
      this.isShowingTouchArea = false
    }, 1000);
  }

  public release() {
  }
}