class RankGroup extends egret.Sprite {

  public constructor(ranks) {
    super()
    this.init(ranks)
  }

  private init(ranks) {
      ranks.forEach((rank, index) => {
          let yPosition = index * 100

          let avatar = new Avatar(rank[0])
          avatar.y = yPosition
          this.addChild(avatar)

          let name = new egret.TextField()
          name.text = rank[0].nick_name
          name.y = yPosition + 40
          name.x = 120
          this.addChild(name)

          let score = new egret.TextField()
          score.text = rank[1]
          score.y = yPosition + 40
          score.x = 500
          this.addChild(score)
      })
  }
}