class Controller extends egret.Sprite {
    private myPosition = {}
    public constructor(isCatcher) {
        super();
        this.init(isCatcher)
    }
 
    private control = new egret.Bitmap()
    private panel = new egret.Shape()

    private up = new egret.Shape()
    private down = new egret.Shape()
    private left = new egret.Shape()
    private right = new egret.Shape()

    // 初始化(给开始按钮绑定点击事件)
    private init(isCatcher) {

        this.panel.graphics.beginFill(isCatcher ? 0x6679BA : 0x353E5D, 1)
        this.panel.graphics.drawRect(1008, 0, 326, 750)
        this.panel.graphics.endFill()
        this.addChild(this.panel)
        
        if(!isCatcher){
            let texture: egret.Texture = RES.getRes("control_jpg")
            this.control.texture = texture

            let controlContainer = new egret.Sprite()
            this.addChild(controlContainer)
            controlContainer.x = 1040
            controlContainer.y = 450
            controlContainer.addChild(this.control)
            this.up.graphics.beginFill(0xFF00FF, 1)
            this.up.graphics.drawRect(93, 0, 80, 80)
            this.up.graphics.endFill()
            this.up.touchEnabled = true
            this.up.alpha = 0
            this.up.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.controlTouchBegin, this)

            this.down.graphics.beginFill(0xFF00FF, 1)
            this.down.graphics.drawRect(93, 186, 80, 80)
            this.down.graphics.endFill()
            this.down.touchEnabled = true
            this.down.alpha = 0
            this.down.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.controlTouchBegin, this)

            this.left.graphics.beginFill(0xFF00FF, 1)
            this.left.graphics.drawRect(0, 93, 80, 80)
            this.left.graphics.endFill()
            this.left.touchEnabled = true
            this.left.alpha = 0
            this.left.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.controlTouchBegin, this)

            this.right.graphics.beginFill(0xFF00FF, 1)
            this.right.graphics.drawRect(186, 93, 80, 80)
            this.right.graphics.endFill()
            this.right.touchEnabled = true
            this.right.alpha = 0
            this.right.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.controlTouchBegin, this)

            controlContainer.addChild(this.up)
            controlContainer.addChild(this.down)
            controlContainer.addChild(this.left)
            controlContainer.addChild(this.right)

            const me = Store.getState().runners.find(runner => runner.t_cid === Store.getState().cid)

            this.myPosition.x = me.x
            this.myPosition.y = me.y
            EventBus.addEventListener('moving', (payload) => {
                if (payload.target.payload.t_cid === Store.getState().cid) {
                    this.myPosition.x = payload.target.payload.x  
                    this.myPosition.y = payload.target.payload.y
                }
            })
        }
    }

    private controlTouchBegin(e: egret.TouchEvent){
        const delta = {x:0, y: 0}
        if(e.currentTarget === this.up){
            delta.y -= 1
        }else if(e.currentTarget === this.down){
            delta.y += 1
        }else if(e.currentTarget === this.left){
            delta.x -= 1
        }else if(e.currentTarget === this.right){
            delta.x += 1
        }

        let newX = this.myPosition.x + delta.x
        let newY = this.myPosition.y + delta.y
        if(newX < 0){
            newX = 0
        }
        if(newY < 0){
            newY = 0
        }
        if(newX >= 13){
            newX = 13
        }
        if(newY >= 9){
            newY = 9
        }

        platform.sendSocketMessage({
            data: JSON.stringify({
                type: 'moving',
                room_id: 'default_room',
                cid: Store.getState().cid,
                payload: {
                    x: newX,
                    y: newY,
                    avatar_url: Store.getState().userInfo.avatarUrl,
                    nick_name: Store.getState().userInfo.nickName
                }
            }),
        })
    }

    public release() {
        // 移除事件
    }
}
