# Introduction

The purpose of this checklist is to get you familiar with the tech stack we use. You should focus on the training project and use the knowledge you learnt from the following training materials to finish it. Other than that, you should finish the following items:

- Version Control
- Basic Ruby & Rails
- Advanced Ruby
- Advanced Rails

You should check out gems mentioned in practical Ruby but there's no need to dig into details.

For other training materials, you don't have to finish them within the training period, but try to learn as much as possible because they will help you in your later work and you will have to learn them sooner or later.

# Version Control

- [Try Git](https://try.github.io/)
- [Git Tutorial](https://git-scm.com/docs/gittutorial)

# Basic Ruby & Rails

- [Try Ruby](http://tryruby.org/)
- [Ruby on Rails tutorials](https://www.railstutorial.org/book)

# Practical Ruby

Check out these gems we use (used, or potentially will use) for production environment and development:
- [x] Web server: Thin, Puma, Unicorn, Rainbows!, Passenger(Raptor)
  - What are the main features provided by these web servers, respectively?
  - Comparing Puma v.s. Unicorn, what are the pros and cons?
- [x] Worker: Sidekiq, Resque
  - Why do we need worker?
  - Sidekiq v.s. Resque
  - Why is Active Job introduced in Rails 4.2? What problem does it solve?
- [x] Web Frameworks: Rails, Sinatra, Grape, Cuba
  - What scenarios are these frameworks designed for, respectively?
  - What problem do they solve, and what problem can they potentially introduce?
- [x] Unit Test Frameworks: RSpec, Minitest
      \* What does spec, mock, and stub mean?
  - Pros and cons of RSpec and Minitest

Check out these critical gems we use in our product:
- [x] [devise](https://github.com/plataformatec/devise)
- [x] [doorkeeper](https://github.com/doorkeeper-gem/doorkeeper)
- [x] [cancancan](https://github.com/CanCanCommunity/cancancan)
- [x] [rollout](https://github.com/FetLife/rollout)
  - What can rollout be used for?
- [x] [multi_json](https://github.com/intridea/multi_json)
  - Why not use built-in JSON processor?
- [x] [faraday](https://github.com/lostisland/faraday)
  - What's the advantage of using faraday?
- [x] [draper](https://github.com/drapergem/draper)
  - What's presenter? What's decorator?
  - Why do we need to use it?
- [x] [sidetiq](https://github.com/tobiassvn/sidetiq)
  - What's the advantage of using sidetiq as scheduler?
- [x] [gon](https://github.com/gazay/gon)
  - What problem does it solve?
- [x] [rabl](https://github.com/nesquena/rabl)
  - Why do we need this?
- [x] [jbuilder](https://github.com/rails/jbuilder)
  - Compare to rabl, what's the pros and cons of jbuilder?
- [x] [dalli](https://github.com/mperham/dalli)

Check out these critical gems we use for BDD:
- [x] [rspec](https://relishapp.com/rspec)
  - What does mock & stub mean?
  - Why do they deprecate old syntax like "should" and "stub"?
- [x] [factory_girl](https://github.com/thoughtbot/factory_girl)
- [x] [vcr](https://github.com/vcr/vcr)
  - What problem does it solve?
- [x] [timecop](https://github.com/travisjeffery/timecop)

# Advanced Ruby

Checkout "Metaprogramming Ruby":
- [x] Chap 1. Metaprogramming Ruby
- [x] Chap 2. Metaprogramming Rails (Optional)
- [x] Chap 3. Idioms, DSL & Spell book (Optional)

Ruby Object Model:
- [x] [Constant Lookup](http://cirw.in/blog/constant-lookup)
- [x] [The Ruby Object Model](https://www.youtube.com/watch?v=X2sgQ38UDVY)


# Advanced Rails

- [x] Asset pipeline
  - Reference: http://guides.rubyonrails.org/asset_pipeline.html
  - What is asset pipeline?
  - How to organize assets?
  - How does caching work for assets?
  - How to customize asset pipeline?
- [x] Rack middleware
  - Reference: http://guides.rubyonrails.org/rails_on_rack.html
  - What is rack?
  - How does rack middleware work?
- [x] Caching with Rails
  - Reference: http://guides.rubyonrails.org/caching_with_rails.html
  - What are the 3 types of caching in Rails?
  - How does caching work?
  - How to configure caching in Rails?
  - Caching best practices
- [x] Rails Security
  - Reference: http://guides.rubyonrails.org/security.html
  - Potential security problem to watch out
  - Security best practices
- [x] [Rails Autoloading](http://urbanautomaton.com/blog/2013/08/27/rails-autoloading-hell/) (optional)
- [x] [Rails upgrading from 3 to 4](http://edgeguides.rubyonrails.org/upgrading_ruby_on_rails.html) (optional)

# Advanced programming techniques
- [x] Inversion of control
  -  Google what you can find about IOC
  - What great improvement can IOC provides to a Rails stack?
  - What benefits can you get with test stack from IOC?
  - How would you implement it in Ruby?
- [x] Single Responsibility Principle
  - Google what you can find about SRP
  - Why is it important principle to follow?
  - Does that apply for processes or data?
  - Can you imagine simple examples of non SRP code where you can explain why not being SRP is a pain?

See Flo to discuss about your research and thoughts.

# Development Workflow

Read the following materials and get familiar with our workflow:
- [x] [Github pull request workflow](http://zachholman.com/talk/how-github-uses-github-to-build-github/)
- [x] [Ruby coding convention](https://github.com/bbatsov/ruby-style-guide)
- [x] [Rails coding convention](https://github.com/bbatsov/rails-style-guide)
- [x] [RSpec best practices](http://betterspecs.org/)
- [x] [Strikingly API convention](https://github.com/strikingly/home/wiki/API-Convention)
- [x] [Spotify software development lifecycle](https://s3.amazonaws.com/uploads.hipchat.com/53157/363231/w6KOrtEE3UJUel7/HowSpotifyBuildsProducts.pdf)
- [x] https://github.com/strikingly/home/wiki/Code-design

See Flo to discuss about rails large scale applications conventions

# Architecture

Our current architecture introduction:

This part will be covered by the backend training session. Please write down your questions if you have any._

- [x] [Strikingly System Architecture](https://github.com/strikingly/Bobcat/wiki/System-Architecture)

Strikingly used to be hosted on Heroku. It is good to get some idea on our old architecture because we borrowed a lot of concepts and best practices from Heroku when designing our new architecture.
- [x] [Architecting Applications for Heroku](https://devcenter.heroku.com/articles/architecting-apps)
- [x] [Worker Dynos, Background Jobs and Queueing](https://devcenter.heroku.com/articles/background-jobs-queueing)
- [x] [Runtime Principles](https://devcenter.heroku.com/articles/runtime-principles)

Here are some best practices on how to build a SaaS platform:
- [x] [12 Factors](http://12factor.net/)

# Third-party Services:

Play around with these 3rd party services we use in daily work:
- [x] Travis-CI
- [x] Code Climate
- [x] Bugsnag
- [x] Logentries
- [x] New Relic (optional)
- [x] Datadog


# Frontend Learning Material (optional)

# LESS & CSS

## Less - 0.5 day
- Read through all of this. http://lesscss.org/features/
- Implement the following "profile card" image using LESS and HTML - pixel perfect, with semantic tags and classes. using external resources for the background image, profile photo, and fonts
  http://dribbble.s3.amazonaws.com/users/329582/screenshots/1180492/slide-59.jpg
- Review the task with Teng

Should be able to answer:
- [x] What's the difference between `position: relative` and `position: static`?
- [x] What are 3 ways to center an element, and when should they be used?
- [x] What are the pros and cons of using `em` units?

# Javascript

Strikingly has a fairly sophisticated frontend system, be sure to familiarize yourself with the following technologies

## Basic Javascript  1-2 days

https://github.com/airbnb/javascript/tree/master/es5 - Familiarize yourself with some basic javascript concepts. Take note that this is a style guide from AirBnb, we don't necessarily follow all the styles (we have our [own](https://github.com/strikingly/javascript) in coffeescript), but it covers a lot of basic javascript concepts.

http://toddmotto.com/everything-you-wanted-to-know-about-javascript-scope/ - Javascript scoping is probably the most misunderstood part of the language. Having a very good command of it can give you the functional power of Javascript.

If you have more time, go to our library and grab Javascript the Good Parts and read it.  Or, go here and read it on your computer: http://www.safaribooksonline.com  Set up a trial account and check out the book. 

Make sure you can answer the following questions before proceeding
- [x] Difference between == and  ===? 
- [x] What's lexical scope?
- [x] What do .bind, .call and .apply do? 
- [x] How to create a object that has private and public scope?
- [x] What are the reserved keywords in javascript that should be avoided?  Why are they reserved?
- [x] How does prototypal inheritance work?

## ES6

All the new modules we write are in ES6, so please get familiar with it.

https://babeljs.io/docs/learn-es2015/ - Introduces ES6 features

https://github.com/strikingly/javascript - Our ES6 coding style

Make sure you can answer the following questions before proceeding
- [x] What problem is rest and spread trying to solve?
- [x] What are the ES6 features covered by Coffeescript?
- [x] What is Babel? What does it try to solve

## React.js  + Flux + Morearty - 1 week
- [x] Go through the tutorial at http://facebook.github.io/react/docs/tutorial.html, ideally go over all the articles in React.js official site.

Task: Build a todo list with no use of flux or anything
- [x] Another very good hands-on tutorial on React and Flux and Immutable.js: http://blog.risingstack.com/the-react-way-getting-started-tutorial/
- [x] Go through Flux tutorial https://facebook.github.io/flux/
- [x] Fluxxor, a variant of Flux, has a really good explanation of Flux: http://fluxxor.com/what-is-flux.html

Task: Build a todo list with the use of flux
- [x] Read about Morearty, and what it does: https://github.com/moreartyjs/moreartyjs

Task: Build a todo list with morearty + flux. 
- [x] Read about redux

Task: Build a todo list with redux

Make sure you can answer the following questions before proceeding
- [x] At which of the React.js component lifecycle are we sure that the DOM has been changed?
- [x] How do we avoid component re-rendering?
- [x] What is a Flux store?
- [x] Why do we need the constants in Flux? 
- [x] What does Immutable.js solve?
- [x] Where do we put async calls? 
- [x] What does Morearty solve?

# Practical Javascript

[npm](http://npmjs.com)
- [x] What are the alternatives to NPM? 
- [x] What is bower? What does bower provide that NPM doesn't? 
- [x] Can we use node.js modules from NPM in our frontend? If yes, what are pros and cons of this approach?  If no, why not?

[webpack](http://webpack.github.io)
- [x] What's the difference between commonjs and AMD? 
- [x] Can we chain loaders?  If so, how would you do this?
- [x] What are the differences between webpack and Require.js? Why do you think we prefer webpack over require.js?
- [x] Write an example code that use code-splitting to async load js chunk

[co](https://github.com/tj/co)
- [x] What's callback hell? 
- [x] How does co avoid this? 
- [x] What are the other alternatives?