require('./init')

import $ from 'jquery'
import React from 'react'
import ReactDOM from 'react-dom'
import cloudinary from 'cloudinary'
import logger from 'js/utils/logger'
import * as i18nHelper from 'js/utils/helpers/i18nHelper'
// import {AppContainer} from 'react-hot-loader'
import * as RHL from 'react-hot-loader'

import { wrapComponentWithReduxStore } from 'js/utils/reduxUtil'
import * as editorStoreCreator from 'js/reducers/editorStoreCreator'

import ComponentKitContext from 'js/utils/ComponentKitContext'
import wrapErrorBoundary from 'js/components/ErrorBoundary'
import 'js/reactInit.es6'

import { initTrack } from 'js/utils/track'

initTrack() // analytics track init

// These two are direct reads so promises can be fired quicker
const supportedVerticals = ['personal']
const themeName = $S.stores.pageMeta.theme.name

const AppContainer = wrapErrorBoundary(RHL.AppContainer)

// Load dynamic editor and theme style files on editor debug environment
if (__MODE__ === "'editor-debug'") {
  require('v4/editor')
  require(`themes/${themeName}/main_v4_editor`)
}

let verticalName = $S.stores.pageMeta.vertical

// only apply supported vertical
if (!supportedVerticals.includes(verticalName)) {
  verticalName = themeName
}

require('./utils/extensions/native')

const p1 = require(`promise-loader?global!locales/${i18nHelper.getTranslationFile()}`)
const p2 = require(`promise-loader?global!manifests/themes/${themeName}.js`)
const p3 = require(`promise-loader?global!manifests/verticals/${verticalName}.js`)

Promise.all([p1(), p2(), p3()])
  .then(([poFile, manifest, vertical]) => {
    const I18n = require('js/utils/i18n')
    I18n.init(poFile)

    const ConfStore = require('js/stores/conf_store')
    cloudinary.config('cloud_name', ConfStore.getCloudinaryCloudName())

    function injectVerticalData() {
      const SectionSelectorStore = require('js/stores/section_selector_store')
      // fill in dynamic default page data based on user or page meta (e.g email)
      const FillInDynamicDefaultThemeData = require('js/utils/themes/FillInDynamicDefaultThemeData')
      manifest = FillInDynamicDefaultThemeData(manifest)

      for (const key in vertical.sectionSelections) {
        const selector = vertical.sectionSelections[key]
        _.merge(selector, manifest.sections[selector.content.template_name])
      }

      SectionSelectorStore.setSelectorData(vertical.sectionSelections)
    }

    if (__NATIVE_WEB__) {
      // TODO: wrap it in another file
      const NativeBridge = require('js/actions/NativeBridge')
      window.NativeBridge = window.NativeBridge || {}
      window.NativeBridge.setTarget = NativeBridge.setTarget
      window.NativeBridge.sendMessageToWeb = NativeBridge.sendMessageToWeb

      const EditorStore = require('./stores/editor_store')
      const Ctx = EditorStore.init()
      EditorStore.hydrate($S.stores)
      require('./v3_bridge')()
      require('js/utils/component_registration')

      $(() => {
        injectVerticalData()
        const ThemeStore = require('js/stores/theme_store')
        ThemeStore.buildAndRegister(manifest)
        const EditorBootstrap = require('js/components/EditorBootstrap')
        const Editor = require('js/components/editor')
        const EditorWrapper = wrapComponentWithReduxStore(
          EditorBootstrap.bootstrap(Ctx.bootstrap(Editor)),
          editorStoreCreator.getStore(),
        )
        const EditorWithContext = ComponentKitContext(EditorWrapper)

        ReactDOM.render(
          <AppContainer>
            <EditorWithContext />
          </AppContainer>,
          document.getElementById('s-editor-container'),
        )
      })
    } else if (__IFRAME_EDITOR__) {
      const ctx = window.parent._ctx.copy()
      // iframe editor will use the same redux store as it's parent
      const editorStore = window.parent._editor_store
      require('./v3_bridge')()
      require('js/utils/component_registration')
      $(() => {
        const ThemeStore = require('js/stores/theme_store')
        ThemeStore.buildAndRegister(manifest)
        const EditorBootstrap = require('js/components/EditorBootstrap')
        const Site = require('js/components/MobileViewSite')
        const SiteWrapper = wrapComponentWithReduxStore(
          ctx.bootstrap(EditorBootstrap.bootstrap(Site)),
          editorStore,
        )
        const EditorWithContext = ComponentKitContext(SiteWrapper)

        ReactDOM.render(
          <AppContainer>
            <EditorWithContext />
          </AppContainer>,
          document.getElementById('s-editor-container'),
        )
      })
    } else {
      window.timerStart = window.timerStart || new Date().getTime()
      window.timerCheck = label => {
        const time = new Date().getTime() - timerStart
        const msg = `#{label} in ${time}ms`
        logger.log(msg)
        return msg
      }
      const EditorStore = require('./stores/editor_store')
      require('./v3_bridge')()
      require('js/utils/component_registration')

      $(() => {
        injectVerticalData()
        const ThemeStore = require('js/stores/theme_store')
        ThemeStore.buildAndRegister(manifest)
        const EditorBootstrap = require('js/components/EditorBootstrap')
        const Editor = require('js/components/editor')

        const Ctx = EditorStore.init()
        EditorStore.hydrate($S.stores)
        const EditorWrapper = wrapComponentWithReduxStore(
          EditorBootstrap.bootstrap(Ctx.bootstrap(Editor)),
          editorStoreCreator.getStore(),
        )
        window._ctx = EditorStore.getCtx()
        // to iframe editor can use the same redux store as it's parent
        window._editor_store = editorStoreCreator.getStore()
        const PageMetaStore = require('./stores/page_meta_store')
        const CurrentUserStore = require('./stores/current_user_store')

        const EditorWithContext = ComponentKitContext(EditorWrapper)

        ReactDOM.render(
          <AppContainer>
            <EditorWithContext />
          </AppContainer>,
          document.getElementById('s-editor-container'),
        )

        if (module.hot) {
          module.hot.accept(['js/components/editor'], () => {
            const Editor = require('js/components/editor')
            const EditorWrapper = wrapComponentWithReduxStore(
              EditorBootstrap.bootstrap(Ctx.bootstrap(Editor)),
              editorStoreCreator.getStore(),
            )
            const EditorWithContext = ComponentKitContext(EditorWrapper)

            ReactDOM.render(
              <AppContainer>
                <EditorWithContext />
              </AppContainer>,
              document.getElementById('s-editor-container'),
            )
          })
        }

        const isStrikinglyReseller =
          CurrentUserStore.isResellerAgent() && !ConfStore.getIsSxl()

        if (
          !ConfStore.getInIosApp() &&
          !ConfStore.getInWeChat() &&
          (!PageMetaStore.isSiteOfResellerClient() ||
            isStrikinglyReseller ||
            ConfStore.getRollout('show_reseller_support_widget'))
        ) {
          const SupportWidget = require('js/components/support_widget/SupportWidget')
          ReactDOM.render(
            <RHL.AppContainer>
              <SupportWidget />
            </RHL.AppContainer>,
            document.getElementById('s-support-widget-container'),
          )
        }
      })
    }
  })
  .catch(error => {
    // catch errors and call console.error so that they are reported by Bugsnag
    console.error('You had an error: ', error.stack)
    throw error
  })

if (module.hot) {
  module.hot.accept(err => {
    if (err) {
      console.error(err)
    }
  })
}
