import init from './init'

/* eslint-disable import/first */

init()

import React from 'react'
import PropTypes from 'prop-types'
import ReactDOM from 'react-dom'
import 'js/reactInit.es6'
import Immutable from 'immutable'
import { createStore, applyMiddleware, compose } from 'redux'
import { combineReducers } from 'redux-immutable'
import { Provider } from 'react-redux'
import {
  Router,
  Route,
  IndexRedirect,
  IndexRoute,
  browserHistory,
} from 'react-router'
import { syncHistoryWithStore } from 'react-router-redux'
import thunkMiddleware from 'redux-thunk'
import { createLogger } from 'redux-logger'
import { Iterable } from 'immutable'
import { AppContainer } from 'react-hot-loader'
import { ErrorBoundary } from 'js/components/ErrorBoundary'
import * as i18nHelper from 'js/utils/helpers/i18nHelper'
import 'js/vendor/jquery/browser'
import ComponentKitContext from 'js/utils/ComponentKitContext'

import reducers from 'nextgen/app/reducers'

import BlogManager from 'nextgen/blog/manager/Manager'
import BlogToWechatPreview from 'nextgen/blog/BlogToWechatPreview'
import SelectTemplate from 'nextgen/app/scenes/SelectTemplate'
import LiveChat from 'nextgen/app/scenes/LiveChat'
import Analytics from 'nextgen/app/scenes/Analytics'
import Preview from 'nextgen/app/scenes/Preview'
import ResellerDashboard from 'nextgen/app/scenes/ResellerDashboard'
import Domains from 'nextgen/app/scenes/Domains'
import Domain from 'nextgen/app/scenes/Domain'
import DomainPurchase from 'nextgen/app/scenes/DomainPurchase'
import DonationManager from 'nextgen/app/scenes/donation/DonationManager'
import ClientTab from 'nextgen/app/scenes/resellerDashboard/ClientTab'
import BillingTab from 'nextgen/app/scenes/resellerDashboard/BillingTab'
import AddCreditTab from 'nextgen/app/scenes/resellerDashboard/AddCreditTab'
import PartnerTab from 'nextgen/app/scenes/resellerDashboard/PartnerTab'
import SalesDashboard from 'nextgen/app/scenes/SalesDashboard'
import ResellerTab from 'nextgen/app/scenes/salesDashboard/ResellerTab'
import StatsTab from 'nextgen/app/scenes/salesDashboard/StatsTab'
import Audience from 'nextgen/app/scenes/audience'
import Miniprogram from 'nextgen/dashboard/miniprogram'
import ComboDashboard from 'nextgen/dashboard/Combo'
import MiniprogramDashboard from 'nextgen/dashboard/miniprogram/components/dashboard'
import MiniprogramSelectTemplate from 'nextgen/dashboard/miniprogram/components/selectTemplate'

/* eslint-enable import/first */

const loggerMiddleware = createLogger({
  collapsed: true,
  predicate: (getState, action) => process.env.NODE_ENV !== 'production',
  stateTransformer: state => {
    if (Iterable.isIterable(state)) {
      return state.toJS()
    }
    return state
  },
})

const middleware = [thunkMiddleware, loggerMiddleware]
// Add the reducer to your store on the `routing` key
const composeEnhancers =
  (localStorage &&
    localStorage.getItem('__strk_developer__') &&
    window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__) ||
  compose
const store = createStore(
  reducers,
  composeEnhancers(applyMiddleware(...middleware)),
)

// Create an enhanced history that syncs navigation events with the store
const history = syncHistoryWithStore(browserHistory, store, {
  selectLocationState: state => state.get('router').toJS(),
})

class RouterComponent extends React.Component {
  static childContextTypes() {
    PropTypes.object
  }

  static getChildContext() {
    return { location: this.props.location }
  }

  render() {
    return (
      <Provider store={store}>
        {/* Tell the Router to use our enhanced history */}
        <Router history={history}>
          <Route path="/s/sites/:siteId/blog/manage" component={BlogManager} />
          <Route
            path="/s/blog_posts/:blogPostId/wechat_preview"
            component={BlogToWechatPreview}
          />
          <Route path="/s/select_template" component={SelectTemplate} />
          <Route path="/s/analytics/:siteId" component={Analytics} />
          <Route path="/s/sites/:siteId/preview" component={Preview} />
          <Route
            path="/s/sites/:siteId/donation/manage"
            component={DonationManager}
          />
          <Route path="/s/reseller" component={ResellerDashboard}>
            <IndexRedirect to="clients" />
            <Route path="clients" component={ClientTab} />
            <Route path="billing" component={BillingTab} />
            <Route path="addcredit" component={AddCreditTab} />
            <Route path="partners" component={PartnerTab} />
            <Route path="select_template" component={SelectTemplate} />
            <Route
              path="select_mini_program_template"
              component={props => (
                <MiniprogramSelectTemplate
                  {...props}
                  skipCategorySelector={true}
                />
              )}
            />
          </Route>
          <Route path="/s/sales" component={SalesDashboard}>
            <IndexRedirect to="resellers" />
            <Route path="resellers" component={ResellerTab} />
            <Route path="stats" component={StatsTab} />
          </Route>
          <Route path="/s/v2_domains" component={Domains} />
          <Route path="/s/v2_domains/purchase" component={DomainPurchase} />
          <Route path="/s/v2_domains/:domainId" component={Domain} />
          <Route path="/s/live_chat" component={LiveChat} />
          <Route path="/s/audience/:id" component={Audience} />
          <Route path="/s/miniprogram" component={Miniprogram}>
            <IndexRoute component={MiniprogramDashboard} />
            <Route
              path="select_template"
              component={MiniprogramSelectTemplate}
            />
          </Route>
          <Route path="/s/reseller/zhubajie/instances" component={ComboDashboard} />
        </Router>
      </Provider>
    )
  }
}

const p1 = import(`locales/${i18nHelper.getTranslationFile()}`)
Promise.all([p1])
  .then(([poFile]) => {
    const I18n = require('js/utils/i18n')
    const cloudinary = require('cloudinary')
    const ConfStore = require('js/stores/conf_store')

    I18n.init(poFile)
    cloudinary.config('cloud_name', ConfStore.getCloudinaryCloudName())

    const RouterComponentWithContext = ComponentKitContext(RouterComponent)

    ReactDOM.render(
      <ErrorBoundary>
        <AppContainer>
          <RouterComponentWithContext />
        </AppContainer>
      </ErrorBoundary>,
      document.getElementById('container'),
    )
  })
  .catch(e => {
    console.error(e, e.stack)
  })

if (module.hot) {
  module.hot.accept(err => {
    if (err) {
      console.error(err)
    }
  })
}
