require('./init')

import React from 'react'
import $ from 'jquery'
import ReactDOM from 'react-dom'
import { AppContainer } from 'react-hot-loader'
import { ErrorBoundary } from 'js/components/ErrorBoundary'
import * as i18nHelper from 'js/utils/helpers/i18nHelper'
import { Provider } from 'react-redux'
import ComponentKitContext from 'js/utils/ComponentKitContext'
import { createStore, applyMiddleware, compose } from 'redux'
import thunkMiddleware from 'redux-thunk'
import {
  Router,
  Route,
  IndexRedirect,
  IndexRoute,
  hashHistory,
} from 'react-router'
import { syncHistoryWithStore } from 'react-router-redux'

import reducers from 'nextgen/app/reducers'

import MiniprogramDashboard from 'nextgen/dashboard/miniprogram/components/dashboard'
import Domains from 'nextgen/app/scenes/Domains'
import Domain from 'nextgen/app/scenes/Domain'
import DomainPurchase from 'nextgen/app/scenes/DomainPurchase'

const middleware = [thunkMiddleware]
const composeEnhancers =
  (localStorage &&
    localStorage.getItem('__strk_developer__') &&
    window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__) ||
  compose
const store = createStore(
  reducers,
  composeEnhancers(applyMiddleware(...middleware)),
)

// Create an enhanced history that syncs navigation events with the store
const history = syncHistoryWithStore(hashHistory, store, {
  selectLocationState: state => state.get('router').toJS(),
})

function EmptyComponent() {
  return <div />
}

function recordLatestViewedHash(nextState, replace) {
  const highlightClass = {
    miniprogram: '.my-miniprogram',
    v2_domains: '.my-domains',
  }[location.hash && location.hash.split('/')[1]]
  $('.subnav-container .s-link')
    .removeClass('current')
    .filter(highlightClass)
    .addClass('current')
  if (localStorage && ['#/miniprogram'].indexOf(location.hash) !== -1) {
    localStorage.setItem('dashboard_latest_viewed_hash', location.hash)
  }
}

class DashboardRouter extends React.Component {
  static childContextTypes() {
    PropTypes.object
  }

  static getChildContext() {
    return { location: this.props.location }
  }

  componentWillMount() {
    $('.nav-menu .s-link')
      .removeClass('current')
      .filter('.my-sites')
      .addClass('current')
  }

  render() {
    return (
      <Provider store={store}>
        <Router history={history}>
          <Route path="/" component={EmptyComponent} />
          <Route
            path="/miniprogram"
            component={MiniprogramDashboard}
            onEnter={recordLatestViewedHash}
          />
          <Route
            path="/v2_domains"
            component={Domains}
            onEnter={recordLatestViewedHash}
          />
          <Route
            path="/v2_domains/purchase"
            component={DomainPurchase}
            onEnter={recordLatestViewedHash}
          />
          <Route
            path="/v2_domains/:domainId"
            component={Domain}
            onEnter={recordLatestViewedHash}
          />
        </Router>
      </Provider>
    )
  }
}

const p1 = import(`locales/${i18nHelper.getTranslationFile()}`)

Promise.all([p1])
  .then(([poFile]) => {
    const I18n = require('js/utils/i18n')
    I18n.init(poFile)
    const DashboardRouterWithContext = ComponentKitContext(DashboardRouter)

    $(() => {
      ReactDOM.render(
        <ErrorBoundary>
          <AppContainer>
            <Provider store={store}>
              <DashboardRouterWithContext />
            </Provider>
          </AppContainer>
        </ErrorBoundary>,
        document.getElementById('mainDashboard'),
      )
    })
  })
  .catch(e => {
    console.error(e, e.stack)
  })

if (module.hot) {
  module.hot.accept(err => {
    if (err) {
      console.error(err)
    }
  })
}
