require('./init')

import createClass from 'create-react-class'
import Morearty from 'morearty'
import React from 'react'
import ReactDOM from 'react-dom'
import $ from 'jquery'
import logger from 'js/utils/logger'

import 'js/vendor/jquery/browser'
import 'js/vendor/jquery/purl'
import 'js/vendor/jquery/tooltip'
import 'js/vendor/jquery/easing'
import 'js/reactInit.es6'

import 'js/v3_bridge/template_helper/modules/core'
import 'js/v3_bridge/template_helper/modules/decorator'
import 'js/v3_bridge/template_helper/modules/event'
import 'js/v3_bridge/template_helper/modules/fixer'
import 'js/v3_bridge/template_helper/modules/util'
import 'js/v3_bridge/template_helper/main'

import TimerMixin from 'react-timer-mixin'

import EditorActions from 'js/actions/editor_actions'
import BlogPostEditorStore from 'js/stores/BlogPostEditorStore'

import CollaboratorsStore from 'js/stores/collaborators_store'
import 'js/stores/BlogPostMetaStore'
import 'js/stores/BlogPostManagerStore'

import 'js/componentsForBlog'

import $B from 'js/v3_bridge/b'

import * as i18nHelper from 'js/utils/helpers/i18nHelper'

import { wrapComponentWithReduxStore } from 'js/utils/reduxUtil'
import * as editorStoreCreator from 'js/reducers/editorStoreCreator'

import ComponentKitContext from 'js/utils/ComponentKitContext'
import connectReduxStoreToBinding from 'js/utils/helpers/connectReduxStoreToBinding'
import { ErrorBoundary } from 'js/components/ErrorBoundary'

if (typeof window.timerStart === 'undefined') {
  window.timerStart = new Date().getTime()
}

window.timerCheck = function(label) {
  const time = new Date().getTime() - window.timerStart
  const msg = `${label} in ${time}ms`
  logger.log(msg)
  return msg
}

window.edit_page = require('js/v3_bridge/edit_page_bridge')

window.edit_page.isBlog = true

// These two are direct reads so promises can be fired quicker
// const locale = $S.globalConf.locale
const themeName = $S.blogPostData.pageMeta.theme.name_with_v4_fallback
const p1 = import(`locales/${i18nHelper.getTranslationFile()}`)
const p2 = import(`manifests/themes/${themeName}.js`)
Promise.all([p1, p2])
  .then(([poFile, manifest]) => {
    const I18n = require('js/utils/i18n')
    I18n.init(poFile)
    const ThemeStore = require('js/stores/theme_store')
    ThemeStore.buildAndRegister(manifest)
    const BootstrapWrapper = createClass({
      mixins: [Morearty.Mixin, TimerMixin],
      componentWillMount() {
        const cloudinary = require('cloudinary')
        const ConfStore = require('js/stores/conf_store')
        cloudinary.config('cloud_name', ConfStore.getCloudinaryCloudName())
      },

      componentDidMount() {
        if (CollaboratorsStore.getLocked()) {
          return EditorActions.openDialog('collaborationWarning')
        }

        if ($.url().param('open') === 'welcome') {
          EditorActions.openDialog('welcomeDialog')
        }

        // setup tooltips
        $('.strikingly-menu-container [rel="tooltip-right"]').tooltip({
          placement: 'right',
          container: '#strikingly-tooltip-container',
        })

        // expend dialog
        try {
          if (
            window !== window.parent &&
            window.parent.edit_page &&
            window.parent.edit_page.blogDialog
          ) {
            window.parent.edit_page.blogDialog.expand()
          }
        } catch (e) {}

        this.setTimeout(() => {
          $B.TH.Fixer.overrideContentLang()
          $B.TH.Fixer.fixNbspForEditor()

          // iframes will use parent's Event first
          // App store should be loaded after main editor to  properly subscribe events from parent
          // If load app store first, then Event is wrong, subscription will fail.
          $B.loadIframe($('#app-store-iframe'))
        }, 0)
      },

      render() {
        const BlogPostEditor = require('js/components/blog/BlogPostEditor')
        return <BlogPostEditor />
      },
    })

    const Ctx = BlogPostEditorStore.init(window.$S)
    const reduxStore = editorStoreCreator.getStore()
    const BlogEditorBootstrap = wrapComponentWithReduxStore(
      Ctx.bootstrap(BootstrapWrapper),
      reduxStore,
    )
    connectReduxStoreToBinding(reduxStore, Ctx.getBinding())
    const BlogEditorWithContext = ComponentKitContext(BlogEditorBootstrap)

    $(() => {
      ReactDOM.render(
        <ErrorBoundary>
          <BlogEditorWithContext />
        </ErrorBoundary>,
        document.getElementById('s-blog-editor-container'),
      )
      window.timerCheck('React has finished rendering')
    })
  })
  .catch(e => console.error(e))
