// Provide webpack modules to v3

// Note: es6 imports will break - Andy Feb 2016
require('./PageSaver')
require('../init')
const I18n = require('js/utils/i18n')
const i18nHelper = require('js/utils/helpers/i18nHelper')

import { AppContainer } from 'react-hot-loader'

// Note: Intially, the following chunk was loaded asynchronously with
// require.ensure, but it breaks on uat of sxl and thus is removed
// Andy Feb 2016

// used in dashboard to send data to angular
import EditPage from 'js/v3_bridge/edit_page_bridge'
import ComponentKitContext from 'js/utils/ComponentKitContext'

let Event = null
window.edit_page = EditPage
try {
  if (parent.window.edit_page && parent.window.edit_page.Event) {
    Event = parent.window.edit_page.Event
    EditPage.Event = Event
  } else {
    Event = EditPage.Event
    if (parent.window.edit_page) {
      parent.window.edit_page.Event = Event
    } else {
      parent.window.edit_page = {
        Event,
      }
    }
  }
} catch (e) {
  if (window.edit_page && window.edit_page.Event) {
    Event = window.edit_page.Event
    EditPage.Event = Event
  } else {
    Event = EditPage.Event
    if (window.edit_page) {
      window.edit_page.Event = Event
    } else {
      window.edit_page = {
        Event,
      }
    }
  }
}

const p1 = require(`promise-loader?global!locales/${i18nHelper.getTranslationFile()}`)
Promise.all([p1()])
  .then(([poFile]) => {
    I18n.init(poFile)
    const $ = require('jquery')
    const React = require('react')
    const ReactDOM = require('react-dom')
    const SupportWidget = require('js/components/support_widget/SupportWidget')
    const PurchaseBridge = require('../../nextgen/domain/PurchaseBridge')
      .default
    const SupportWidgetWithComponentKit = ComponentKitContext(SupportWidget)

    const PublishManager = require('nextgen/subApps/publishManager')
    PublishManager.bindToGlobal()

    $(() => {
      const supportWidgetContainer = document.getElementById(
        's-support-widget-container',
      )

      if (supportWidgetContainer) {
        ReactDOM.render(
          <AppContainer>
            <SupportWidgetWithComponentKit />
          </AppContainer>,
          supportWidgetContainer,
        )
      }

      PurchaseBridge({
        Event,
      })
    })
  })
  .catch(e => console.error(e))

if (module.hot) {
  module.hot.accept(err => {
    if (err) {
      console.error(err)
    }
  })
}
