// const path = require('path')
const fs = require('fs')
const path = require('path')
const shell = require('shelljs')
const handlebars = require('handlebars')

const { TEMPLATES, PACKAGES, LEGACY_CODES, BACKUP_FILES } = require('./configs')

handlebars.registerHelper('if_eq', function(a, b, opts) {
  return a === b ? opts.fn(this) : opts.inverse(this)
})

const preserveOldFiles = () => {
  BACKUP_FILES.forEach(file => {
    console.log(`Preserving ${file} ...`)
    const basename = path.basename(file)
    fs.copyFileSync(file, `${__dirname}/backups/${basename}`)
  })
}

const restoreOldFiles = () => {
  BACKUP_FILES.forEach(file => {
    console.log(`Restoring ${file} ...`)
    const basename = path.basename(file)
    fs.copyFileSync(`${__dirname}/backups/${basename}`, file)
  })
}

const updateConfigFiles = (mode = 'chill') => {
  TEMPLATES.forEach(filename => {
    const content = fs.readFileSync(
      `${__dirname}/templates/${filename}.template`,
      'utf8'
    )
    const template = handlebars.compile(content)
    const output = template({ mode })
    fs.writeFileSync(filename, output, 'utf8')
  })
}

const updateLegacyCodes = () => {
  LEGACY_CODES.forEach(({ name, update }) => {
    const content = fs.readFileSync(name, 'utf8')
    const output = update(content)
    fs.writeFileSync(name, output, 'utf8')
  })
}

const upgradePackages = () => {
  const command =
    'yarn add -D ' +
    PACKAGES.map(({ name, version }) => `${name}@${version}`).join(' ')
  const { code, stderr } = shell.exec(command)
  if (!code) console.error(stderr)
}

module.exports = {
  preserveOldFiles,
  restoreOldFiles,
  updateConfigFiles,
  updateLegacyCodes,
  upgradePackages
}
