'use strict'
!(function(require, directRequire) {
  const a = require('react')
  module.exports = class extends a.Component {
    constructor(a) {
      if ((super(a), !this.props.items))
        throw new TypeError(
          'Subpackge Popover component: attribute "items" must be provided'
        )
      this.state = {}
    }
    onClick(a) {
      a.stopPropagation()
    }
    onCancel() {
      this.props.onCancel && this.props.onCancel()
    }
    render() {
      const b = (this.props.items || []).map(b => {
          let c = b.current || {},
            d = b.latest || {}
          return a.createElement(
            'div',
            { className: 'plugins-item', key: b.appid },
            a.createElement(
              'h4',
              { className: 'plugins-item-name ui-flex' },
              a.createElement('span', { className: 'ui-flex-item' }, b.name)
            ),
            a.createElement(
              'div',
              { className: 'plugins-item-meta' },
              a.createElement(
                'label',
                { className: 'plugins-item-meta-key' },
                'AppId'
              ),
              a.createElement(
                'p',
                { className: 'plugins-item-meta-value' },
                b.appid
              )
            ),
            a.createElement(
              'div',
              { className: 'plugins-item-meta' },
              a.createElement(
                'label',
                { className: 'plugins-item-meta-key' },
                '\u5F53\u524D\u7248\u672C'
              ),
              a.createElement(
                'p',
                { className: 'plugins-item-meta-value' },
                c.version || '\u65E0',
                ' ',
                (c.pkgSize && `(${(c.pkgSize / 1024).toFixed(1)} KB)`) || '',
                ' ',
                c.version === d.version ? ' - \u6700\u65B0' : ''
              )
            ),
            c.version === d.version
              ? null
              : a.createElement(
                  'div',
                  { className: 'plugins-item-meta' },
                  a.createElement(
                    'label',
                    { className: 'plugins-item-meta-key' },
                    '\u6700\u65B0\u7248\u672C'
                  ),
                  a.createElement(
                    'p',
                    { className: 'plugins-item-meta-value' },
                    d.version || '\u65E0',
                    ' ',
                    (d.pkgSize && `(${(d.pkgSize / 1024).toFixed(1)} KB)`) ||
                      '',
                    ' ',
                    a.createElement('i', { className: 'ui-icon-dot' })
                  )
                )
          )
        }),
        c = { WebkitAppRegion: 'no-drag', position: 'absolute' }
      return (
        ['left', 'top'].forEach(a => {
          this.props.hasOwnProperty(a) && (c[a] = this.props[a])
        }),
        a.createElement(
          'div',
          { className: 'ui-popover', style: c, onClick: this.onClick },
          a.createElement(
            'div',
            { className: 'plugins' },
            a.createElement(
              'div',
              { className: 'plugins-hd ui-flex' },
              a.createElement(
                'h3',
                { className: 'plugins-title ui-flex-item' },
                '\u63D2\u4EF6\u4FE1\u606F'
              ),
              a.createElement(
                'div',
                { className: 'plugins-hd-ext' },
                a.createElement('i', {
                  className: 'ui-icon-notify-close',
                  onClick: this.onCancel.bind(this)
                })
              )
            ),
            a.createElement(
              'div',
              { className: 'plugins-bd' },
              a.createElement('div', { className: 'plugins-list' }, b)
            )
          )
        )
      )
    }
  }
})(require('lazyload'), require)
