window.API.JSAPIMonaco = "\ninterface CanvasContext {\n\n/**\n * 创建一个颜色的渐变点。\n */\naddColorStop: () => void,\n\n\n/**\n * 画一条弧线。\n */\narc: () => void,\n\n\n/**\n * 开始创建一个路径，需要调用fill或者stroke才会使用路径进行填充或描边。\n */\nbeginPath: () => void,\n\n\n/**\n * 创建三次方贝塞尔曲线路径。\n */\nbezierCurveTo: () => void,\n\n\n/**\n * 清空绘图上下文的绘图动作。\n */\nclearActions: () => void,\n\n\n/**\n * 清除画布上在该矩形区域内的内容。\n */\nclearRect: () => void,\n\n\n/**\n * 关闭一个路径\n */\nclosePath: () => void,\n\n\n/**\n * 创建一个圆形的渐变颜色。\n */\ncreateCircularGradient: () => void,\n\n\n/**\n * 创建一个线性的渐变颜色。\n */\ncreateLinearGradient: () => void,\n\n\n/**\n * 将之前在绘图上下文中的描述（路径、变形、样式）画到 canvas 中。\n */\ndraw: () => void,\n\n\n/**\n * 绘制图像，图像保持原始尺寸。\n */\ndrawImage: () => void,\n\n\n/**\n * 对当前路径中的内容进行填充。默认的填充色为黑色。\n */\nfill: () => void,\n\n\n/**\n * 填充一个矩形。\n */\nfillRect: () => void,\n\n\n/**\n * 在画布上绘制被填充的文本。\n */\nfillText: () => void,\n\n\n/**\n * const ctx = wx.createCanvasContext('myCanvas')\n */\nlineTo: () => void,\n\n\n/**\n * 把路径移动到画布中的指定点，不创建线条。\n */\nmoveTo: () => void,\n\n\n/**\n * 创建二次贝塞尔曲线路径。\n */\nquadraticCurveTo: () => void,\n\n\n/**\n * 创建一个矩形。\n */\nrect: () => void,\n\n\n/**\n * 以原点为中心，原点可以用 [translate](#translate)方法修改。顺时针旋转当前坐标轴。多次调用`rotate`，旋转的角度会叠加。\n */\nrotate: () => void,\n\n\n/**\n * 保存当前的绘图上下文。\n */\nsave: () => void,\n\n\n/**\n * 在调用`scale`方法后，之后创建的路径其横纵坐标会被缩放。多次调用`scale`，倍数会相乘。\n */\nscale: () => void,\n\n\n/**\n * 设置填充色。\n */\nsetFillStyle: () => void,\n\n\n/**\n * 设置字体的字号。\n */\nsetFontSize: () => void,\n\n\n/**\n * 设置全局画笔透明度。\n */\nsetGlobalAlpha: () => void,\n\n\n/**\n * 设置线条的端点样式。\n */\nsetLineCap: () => void,\n\n\n/**\n * 设置线条的交点样式。\n */\nsetLineJoin: () => void,\n\n\n/**\n * 设置线条的宽度。\n */\nsetLineWidth: () => void,\n\n\n/**\n * 设置最大斜接长度，斜接长度指的是在两条线交汇处内角和外角之间的距离。 当 `setLineJoin()` 为 miter 时才有效。超过最大倾斜长度的，连接处将以 lineJoin 为 bevel 来显示\n */\nsetMiterLimit: () => void,\n\n\n/**\n * 设置阴影样式。\n */\nsetShadow: () => void,\n\n\n/**\n * 设置边框颜色。\n */\nsetStrokeStyle: () => void,\n\n\n/**\n * 用于设置文字的对齐\n */\nsetTextAlign: () => void,\n\n\n/**\n * 用于设置文字的水平对齐\n */\nsetTextBaseline: () => void,\n\n\n/**\n * 画出当前路径的边框。默认颜色色为黑色。\n */\nstroke: () => void,\n\n\n/**\n * 画一个矩形(非填充)。\n */\nstrokeRect: () => void,\n\n\n/**\n * 对当前坐标系的原点(0, 0)进行变换，默认的坐标系原点为页面左上角。\n */\ntranslate: () => void,\n\n\n}\n\ninterface _writeBLECharacteristicValueObject {\n\n/**\n * 蓝牙设备 id，参考 device 对象\n */\ndeviceId: string,\n\n/**\n * 蓝牙特征值对应服务的 uuid\n */\nserviceId: string,\n\n/**\n * 蓝牙特征值的 uuid\n */\ncharacteristicId: string,\n\n/**\n * 蓝牙设备特征值对应的二进制值**（注意：vConsole 无法打印出 ArrayBuffer 类型数据）**\n */\nvalue: any,\n\n/**\n * 成功则返回本机蓝牙适配器状态\n */\nsuccess: (result: _writeBLECharacteristicValueSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\n\ninterface _writeBLECharacteristicValueSuccessObject {\n\n/**\n * 成功：ok，错误：详细信息\n */\nerrMsg: string,\n\n}\n\ninterface _vibrateShortObject {\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _vibrateLongObject {\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _uploadFileObject {\n\n/**\n * 开发者服务器 url\n */\nurl: string,\n\n/**\n * 要上传文件资源的路径\n */\nfilePath: string,\n\n/**\n * 文件对应的 key , 开发者在服务器端通过这个 key 可以获取到文件二进制内容\n */\nname: string,\n\n/**\n * HTTP 请求 Header , header 中不能设置 Referer\n */\nheader: object,\n\n/**\n * HTTP 请求中其他额外的 form data\n */\nformData: object,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _uploadFileSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _uploadFileSuccessObject {\n\n/**\n * 开发者服务器返回的数据\n */\ndata: string,\n\n/**\n * HTTP状态码\n */\nstatusCode: number,\n\n}\n\ninterface _updateShareMenuObject {\n\n/**\n * 是否使用带 shareTicket 的转发[详情](./share.md#获取更多转发信息)\n */\nwithShareTicket: boolean,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _switchTabObject {\n\n/**\n * 需要跳转的 tabBar 页面的路径（需在 app.json 的 [tabBar](../framework/config.md#tabbar) 字段定义的页面），路径后不能带参数\n */\nurl: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _stopCompassObject {\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _stopBluetoothDevicesDiscoveryObject {\n\n/**\n * 成功则返回本机蓝牙适配器状态\n */\nsuccess: (result: _stopBluetoothDevicesDiscoverySuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _stopBluetoothDevicesDiscoverySuccessObject {\n\n/**\n * 成功：ok，错误：详细信息\n */\nerrMsg: string,\n\n}\n\ninterface _stopBeaconDiscoveryObject {\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _stopBeaconDiscoverySuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _stopBeaconDiscoverySuccessObject {\n\n/**\n * 调用结果\n */\nerrMsg: string,\n\n}\n\ninterface _stopAccelerometerObject {\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _startRecordObject {\n\n/**\n * 录音成功后调用，返回录音文件的临时文件路径，res = {tempFilePath: '录音文件的临时路径'}\n */\nsuccess: (result: _startRecordSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _startRecordSuccessObject {\n\n/**\n * 录音文件的临时路径\n */\ntempFilePath: any,\n\n}\n\ninterface _startCompassObject {\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _startBluetoothDevicesDiscoveryObject {\n\n/**\n * 蓝牙设备主 service 的 uuid 列表\n */\nservices: any,\n\n/**\n * 是否允许重复上报同一设备， 如果允许重复上报，则onDeviceFound 方法会多次上报同一设备，但是 RSSI 值会有不同\n */\nallowDuplicatesKey: boolean,\n\n/**\n * 上报设备的间隔，默认为0，意思是找到新设备立即上报，否则根据传入的间隔上报\n */\ninterval: any,\n\n/**\n * 成功则返回本机蓝牙适配器状态\n */\nsuccess: (result: _startBluetoothDevicesDiscoverySuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _startBluetoothDevicesDiscoverySuccessObject {\n\n/**\n * 成功：ok，错误：详细信息\n */\nerrMsg: string,\n\n/**\n * 当前蓝牙适配器是否处于搜索状态\n */\nisDiscovering: boolean,\n\n}\n\ninterface _startBeaconDiscoveryObject {\n\n/**\n * iBeacon设备广播的 uuids\n */\nuuids: any,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _startBeaconDiscoverySuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _startBeaconDiscoverySuccessObject {\n\n/**\n * 调用结果\n */\nerrMsg: string,\n\n}\n\ninterface _startAccelerometerObject {\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _showToastObject {\n\n/**\n * 提示的内容\n */\ntitle: string,\n\n/**\n * 图标，有效值 \"success\", \"loading\"\n */\nicon: string,\n\n/**\n * 自定义图标的本地路径，image 的优先级高于 icon\n */\nimage: string,\n\n/**\n * 提示的延迟时间，单位毫秒，默认：1500\n */\nduration: number,\n\n/**\n * 是否显示透明蒙层，防止触摸穿透，默认：false\n */\nmask: boolean,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _showShareMenuObject {\n\n/**\n * 是否使用带 shareTicket 的转发[详情](./share.md#获取更多转发信息)\n */\nwithShareTicket: boolean,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _showModalObject {\n\n/**\n * 提示的标题\n */\ntitle: string,\n\n/**\n * 提示的内容\n */\ncontent: string,\n\n/**\n * 是否显示取消按钮，默认为 true\n */\nshowCancel: boolean,\n\n/**\n * 取消按钮的文字，默认为\"取消\"，最多 4 个字符\n */\ncancelText: string,\n\n/**\n * 取消按钮的文字颜色，默认为\"#000000\"\n */\ncancelColor: any,\n\n/**\n * 确定按钮的文字，默认为\"确定\"，最多 4 个字符\n */\nconfirmText: string,\n\n/**\n * 确定按钮的文字颜色，默认为\"#3CC51F\"\n */\nconfirmColor: any,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _showModalSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _showModalSuccessObject {\n\n/**\n * 为 true 时，表示用户点击了确定按钮\n */\nconfirm: boolean,\n\n/**\n * 为 true 时，表示用户点击了取消（用于 Android 系统区分点击蒙层关闭还是点击取消按钮关闭）\n */\ncancel: boolean,\n\n}\n\ninterface _showLoadingObject {\n\n/**\n * 提示的内容\n */\ntitle: string,\n\n/**\n * 是否显示透明蒙层，防止触摸穿透，默认：false\n */\nmask: boolean,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _showActionSheetObject {\n\n/**\n * 按钮的文字数组，数组长度最大为6个\n */\nitemList: any,\n\n/**\n * 按钮的文字颜色，默认为\"#000000\"\n */\nitemColor: any,\n\n/**\n * 接口调用成功的回调函数，详见返回参数说明\n */\nsuccess: (result: _showActionSheetSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _showActionSheetSuccessObject {\n\n/**\n * 用户点击的按钮，从上到下的顺序，从0开始\n */\ntapIndex: number,\n\n}\n\ninterface _setStorageObject {\n\n/**\n * 本地缓存中的指定的 key\n */\nkey: string,\n\n/**\n * 需要存储的内容\n */\ndata: any,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _setScreenBrightnessObject {\n\n/**\n * 屏幕亮度值，范围 0~1，0 最暗，1 最亮\n */\nvalue: number,\n\n/**\n * 接口调用成功\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _setNavigationBarTitleObject {\n\n/**\n * 页面标题\n */\ntitle: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _setNavigationBarColorObject {\n\n/**\n * 前景颜色值，包括按钮、标题、状态栏的颜色，仅支持 #ffffff 和 #000000\n */\nfrontColor: string,\n\n/**\n * 背景颜色值，有效值为十六进制颜色\n */\nbackgroundColor: string,\n\n/**\n * 动画效果\n */\nanimation: object,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _setNavigationBarColorSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _setNavigationBarColorSuccessObject {\n\n/**\n * 调用结果\n */\nerrMsg: string,\n\n}\n\ninterface _setKeepScreenOnObject {\n\n/**\n * 是否保持屏幕常亮\n */\nkeepScreenOn: boolean,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _setKeepScreenOnSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _setKeepScreenOnSuccessObject {\n\n/**\n * 调用结果\n */\nerrMsg: string,\n\n}\n\ninterface _setEnableDebugObject {\n\n/**\n * 是否打开调试\n */\nenableDebug: boolean,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _setEnableDebugSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _setEnableDebugSuccessObject {\n\n/**\n * 调用结果\n */\nerrMsg: string,\n\n}\n\ninterface _setClipboardDataObject {\n\n/**\n * 需要设置的内容\n */\ndata: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _sendSocketMessageObject {\n\n/**\n * 需要发送的内容\n */\ndata: any,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _seekBackgroundAudioObject {\n\n/**\n * 音乐位置，单位：秒\n */\nposition: number,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _scanCodeObject {\n\n/**\n * 是否只能从相机扫码，不允许从相册选择图片\n */\nonlyFromCamera: boolean,\n\n/**\n * 接口调用成功的回调函数，返回内容详见返回参数说明。\n */\nsuccess: (result: _scanCodeSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _scanCodeSuccessObject {\n\n/**\n * 所扫码的内容\n */\nresult: any,\n\n/**\n * 所扫码的类型\n */\nscanType: any,\n\n/**\n * 所扫码的字符集\n */\ncharSet: any,\n\n/**\n * 当所扫的码为当前小程序的合法二维码时，会返回此字段，内容为二维码携带的 path\n */\npath: any,\n\n}\n\ninterface _saveVideoToPhotosAlbumObject {\n\n/**\n * 视频文件路径，可以是临时文件路径也可以是永久文件路径\n */\nfilePath: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _saveVideoToPhotosAlbumSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _saveVideoToPhotosAlbumSuccessObject {\n\n/**\n * 调用结果\n */\nerrMsg: string,\n\n}\n\ninterface _saveImageToPhotosAlbumObject {\n\n/**\n * 图片文件路径，可以是临时文件路径也可以是永久文件路径，不支持网络图片路径\n */\nfilePath: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _saveImageToPhotosAlbumSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _saveImageToPhotosAlbumSuccessObject {\n\n/**\n * 调用结果\n */\nerrMsg: string,\n\n}\n\ninterface _saveFileObject {\n\n/**\n * 需要保存的文件的临时路径\n */\ntempFilePath: string,\n\n/**\n * 返回文件的保存路径，res = {savedFilePath: '文件的保存路径'}\n */\nsuccess: (result: _saveFileSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _saveFileSuccessObject {\n\n/**\n * 文件的保存路径\n */\nsavedFilePath: any,\n\n}\n\ninterface _requestPaymentObject {\n\n/**\n * 时间戳从1970年1月1日00:00:00至今的秒数,即当前的时间\n */\ntimeStamp: string,\n\n/**\n * 随机字符串，长度为32个字符以下。\n */\nnonceStr: string,\n\n/**\n * 统一下单接口返回的 prepay_id 参数值，提交格式如：prepay_id=***\n */\npackage: string,\n\n/**\n * 签名算法，暂支持 MD5\n */\nsignType: string,\n\n/**\n * 签名,具体签名方案参见[小程序支付接口文档](https://pay.weixin.qq.com/wiki/doc/api/wxa/wxa_api.php?chapter=7_7&index=3);\n */\npaySign: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _requestObject {\n\n/**\n * 开发者服务器接口地址\n */\nurl: string,\n\n/**\n * 请求的参数\n */\ndata: any,\n\n/**\n * 设置请求的 header , header 中不能设置 Referer\n */\nheader: object,\n\n/**\n * 默认为 GET，有效值：OPTIONS, GET, HEAD, POST, PUT, DELETE, TRACE, CONNECT\n */\nmethod: string,\n\n/**\n * 默认为 json。如果设置了 dataType 为 json，则会尝试对响应的数据做一次 JSON.parse\n */\ndataType: string,\n\n/**\n * 收到开发者服务成功返回的回调函数，res = {data: '开发者服务器返回的内容'}\n */\nsuccess: (result: _requestSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _requestSuccessObject {\n\n/**\n * 开发者服务器返回的数据\n */\ndata: any,\n\n/**\n * 开发者服务器返回的状态码\n */\nstatusCode: any,\n\n/**\n * 开发者服务器返回的 HTTP Response Header\n */\nheader: any,\n\n}\n\ninterface _removeStorageObject {\n\n/**\n * 本地缓存中的指定的 key\n */\nkey: string,\n\n/**\n * 接口调用的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _removeSavedFileObject {\n\n/**\n * 需要删除的文件路径\n */\nfilePath: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _redirectToObject {\n\n/**\n * 需要跳转的应用内非 tabBar 的页面的路径，路径后可以带参数。参数与路径之间使用`?`分隔，参数键与参数值用`=`相连，不同参数用`&`分隔；如 'path?key=value&key2=value2'\n */\nurl: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _readBLECharacteristicValueObject {\n\n/**\n * 蓝牙设备 id，参考 device 对象\n */\ndeviceId: string,\n\n/**\n * 蓝牙特征值对应服务的 uuid\n */\nserviceId: string,\n\n/**\n * 蓝牙特征值的 uuid\n */\ncharacteristicId: string,\n\n/**\n * 成功则返回本机蓝牙适配器状态\n */\nsuccess: (result: _readBLECharacteristicValueSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _readBLECharacteristicValueSuccessObject {\n\n/**\n * 设备特征值信息\n */\ncharacteristic: object,\n\n/**\n * 成功：ok，错误：详细信息\n */\nerrMsg: string,\n\n}\n\ninterface _reLaunchObject {\n\n/**\n * 需要跳转的应用内页面路径 , 路径后可以带参数。参数与路径之间使用`?`分隔，参数键与参数值用`=`相连，不同参数用`&`分隔；如 'path?key=value&key2=value2'，如果跳转的页面路径是 tabBar 页面则不能带参数\n */\nurl: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _previewImageObject {\n\n/**\n * 当前显示图片的链接，不填则默认为 urls 的第一张\n */\ncurrent: string,\n\n/**\n * 需要预览的图片链接列表\n */\nurls: any,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _playVoiceObject {\n\n/**\n * 需要播放的语音文件的文件路径\n */\nfilePath: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _playBackgroundAudioObject {\n\n/**\n * 音乐链接\n */\ndataUrl: string,\n\n/**\n * 音乐标题\n */\ntitle: string,\n\n/**\n * 封面URL\n */\ncoverImgUrl: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _pageScrollToObject {\n\n/**\n * 滚动到页面的目标位置（单位px）\n */\nscrollTop: number,\n\n}\ninterface _openSettingObject {\n\n/**\n * 接口调用成功的回调函数，返回内容详见返回参数说明。\n */\nsuccess: (result: _openSettingSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _openSettingSuccessObject {\n\n/**\n * 用户授权结果，其中 key 为 scope 值，value 为 Bool 值，表示用户是否允许授权，详见 [scope 列表](./authorize.md#scope-列表)\n */\nauthSetting: object,\n\n}\n\ninterface _openLocationObject {\n\n/**\n * 纬度，范围为-90~90，负数表示南纬\n */\nlatitude: any,\n\n/**\n * 经度，范围为-180~180，负数表示西经\n */\nlongitude: any,\n\n/**\n * 缩放比例，范围5~18，默认为18\n */\nscale: any,\n\n/**\n * 位置名\n */\nname: string,\n\n/**\n * 地址的详细说明\n */\naddress: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _openDocumentObject {\n\n/**\n * 文件路径，可通过 downFile 获得\n */\nfilePath: any,\n\n/**\n * 文件类型，指定文件类型打开文件，有效值 doc, xls, ppt, pdf, docx, xlsx, pptx\n */\nfileType: any,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: any,\n\n/**\n * 接口调用失败的回调函数\n */\nfail: any,\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: any,\n\n}\ninterface _openCardObject {\n\n/**\n * 需要打开的卡券列表，列表内参数详见[openCard 请求对象说明](#opencard-请求对象说明)\n */\ncardList: any,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _openBluetoothAdapterObject {\n\n/**\n * 成功则返回成功初始化信息\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _onUserCaptureScreenCallbackResult {\n\n}\ninterface _onSocketMessageCallbackResult {\n\n/**\n * 服务器返回的消息\n */\ndata: any,\n\n}\ninterface _onNetworkStatusChangeCallbackResult {\n\n/**\n * 当前是否有网络连接\n */\nisConnected: boolean,\n\n/**\n * 网络类型\n */\nnetworkType: string,\n\n}\ninterface _onCompassChangeCallbackResult {\n\n/**\n * 面对的方向度数\n */\ndirection: number,\n\n}\ninterface _onBluetoothDeviceFoundCallbackResult {\n\n/**\n * 新搜索到的设备列表\n */\ndevices: any,\n\n}\ninterface _onBluetoothAdapterStateChangeCallbackResult {\n\n/**\n * 蓝牙适配器是否可用\n */\navailable: boolean,\n\n/**\n * 蓝牙适配器是否处于搜索状态\n */\ndiscovering: boolean,\n\n}\ninterface _onBeaconUpdateCallbackResult {\n\n/**\n * 当前搜寻到的所有 iBeacon 设备列表\n */\nbeacons: any,\n\n}\ninterface _onBeaconServiceChangeCallbackResult {\n\n/**\n * 服务目前是否可用\n */\navailable: boolean,\n\n/**\n * 目前是否处于搜索状态\n */\ndiscovering: boolean,\n\n}\ninterface _onBLEConnectionStateChangeCallbackResult {\n\n/**\n * 蓝牙设备 id，参考 device 对象\n */\ndeviceId: string,\n\n/**\n * 连接目前的状态\n */\nconnected: boolean,\n\n}\ninterface _onBLECharacteristicValueChangeCallbackResult {\n\n/**\n * 蓝牙设备 id，参考 device 对象\n */\ndeviceId: string,\n\n/**\n * 特征值所属服务 uuid\n */\nserviceId: string,\n\n/**\n * 特征值 uuid\n */\ncharacteristicId: string,\n\n/**\n * 特征值最新的值**（注意：vConsole 无法打印出 ArrayBuffer 类型数据）**\n */\nvalue: any,\n\n}\ninterface _onAccelerometerChangeCallbackResult {\n\n/**\n * X 轴\n */\nx: number,\n\n/**\n * Y 轴\n */\ny: number,\n\n/**\n * Z 轴\n */\nz: number,\n\n}\ninterface _notifyBLECharacteristicValueChangeObject {\n\n/**\n * 蓝牙设备 id，参考 device 对象\n */\ndeviceId: string,\n\n/**\n * 蓝牙特征值对应服务的 uuid\n */\nserviceId: string,\n\n/**\n * 蓝牙特征值的 uuid\n */\ncharacteristicId: string,\n\n/**\n * true: 启用 notify; false: 停用 notify\n */\nstate: boolean,\n\n/**\n * 成功则返回本机蓝牙适配器状态\n */\nsuccess: (result: _notifyBLECharacteristicValueChangeSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _notifyBLECharacteristicValueChangeSuccessObject {\n\n/**\n * 成功：ok，错误：详细信息\n */\nerrMsg: string,\n\n}\n\ninterface _navigateToMiniProgramObject {\n\n/**\n * 要打开的小程序 appId\n */\nappId: string,\n\n/**\n * 打开的页面路径，如果为空则打开首页\n */\npath: string,\n\n/**\n * 需要传递给目标小程序的数据，目标小程序可在 `App.onLaunch()`，`App.onShow()` 中获取到这份数据。[详情](../framework/app-service/app.md)\n */\nextraData: object,\n\n/**\n * 要打开的小程序版本，有效值 develop（开发版），trial（体验版），release（正式版） ，仅在当前小程序为开发版或体验版时此参数有效；如果当前小程序是体验版或正式版，则打开的小程序必定是正式版。默认值 release\n */\nenvVersion: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _navigateToMiniProgramSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _navigateToMiniProgramSuccessObject {\n\n/**\n * 调用结果\n */\nerrMsg: string,\n\n}\n\ninterface _navigateToObject {\n\n/**\n * 需要跳转的应用内非 tabBar 的页面的路径 , 路径后可以带参数。参数与路径之间使用`?`分隔，参数键与参数值用`=`相连，不同参数用`&`分隔；如 'path?key=value&key2=value2'\n */\nurl: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _navigateBackMiniProgramObject {\n\n/**\n * 需要返回给上一个小程序的数据，上一个小程序可在 `App.onShow()` 中获取到这份数据。[详情](../framework/app-service/app.md)\n */\nextraData: object,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _navigateBackMiniProgramSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _navigateBackMiniProgramSuccessObject {\n\n/**\n * 调用结果\n */\nerrMsg: string,\n\n}\n\ninterface _navigateBackObject {\n\n/**\n * 返回的页面数，如果 delta 大于现有页面数，则返回到首页。\n */\ndelta: number,\n\n}\ninterface _makePhoneCallObject {\n\n/**\n * 需要拨打的电话号码\n */\nphoneNumber: string,\n\n/**\n * 接口调用成功的回调\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _loginObject {\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _loginSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _loginSuccessObject {\n\n/**\n * 调用结果\n */\nerrMsg: string,\n\n/**\n * 用户允许登录后，回调内容会带上 code（有效期五分钟），开发者需要将 code 发送到开发者服务器后台，使用`code 换取 session_key` api，将 code 换成 openid 和 session_key\n */\ncode: string,\n\n}\n\ninterface _hideShareMenuObject {\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getWeRunDataObject {\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _getWeRunDataSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getWeRunDataSuccessObject {\n\n/**\n * 调用结果\n */\nerrMsg: string,\n\n/**\n * 包括敏感数据在内的完整用户信息的加密数据，详细见[加密数据解密算法](./signature.md#加密数据解密算法)\n */\nencryptedData: string,\n\n/**\n * 加密算法的初始向量，详细见[加密数据解密算法](./signature.md#加密数据解密算法)\n */\niv: string,\n\n}\n\ninterface _getUserInfoObject {\n\n/**\n * 是否带上登录态信息\n */\nwithCredentials: boolean,\n\n/**\n * 指定返回用户信息的语言，zh_CN 简体中文，zh_TW 繁体中文，en 英文\n */\nlang: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _getUserInfoSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getUserInfoSuccessObject {\n\n/**\n * 用户信息对象，不包含 openid 等敏感信息\n */\nuserInfo: object,\n\n/**\n * 不包括敏感信息的原始数据字符串，用于计算签名。\n */\nrawData: string,\n\n/**\n * 使用 sha1( rawData + sessionkey ) 得到字符串，用于校验用户信息，参考文档 [signature](./signature.md)。\n */\nsignature: string,\n\n/**\n * 包括敏感数据在内的完整用户信息的加密数据，详细见[加密数据解密算法](./signature.md#加密数据解密算法)\n */\nencryptedData: string,\n\n/**\n * 加密算法的初始向量，详细见[加密数据解密算法](./signature.md#加密数据解密算法)\n */\niv: string,\n\n}\n\ninterface _getSystemInfoSyncReturnValue {\n\n/**\n * 手机型号\n */\nmodel: any,\n\n/**\n * 设备像素比\n */\npixelRatio: any,\n\n/**\n * 屏幕宽度\n */\nscreenWidth: any,\n\n/**\n * 屏幕高度\n */\nscreenHeight: any,\n\n/**\n * 可使用窗口宽度\n */\nwindowWidth: any,\n\n/**\n * 可使用窗口高度\n */\nwindowHeight: any,\n\n/**\n * 微信设置的语言\n */\nlanguage: any,\n\n/**\n * 微信版本号\n */\nversion: any,\n\n/**\n * 操作系统版本\n */\nsystem: any,\n\n/**\n * 客户端平台\n */\nplatform: any,\n\n/**\n * 客户端基础库版本\n */\nSDKVersion: any,\n\n}\n\ninterface _getSystemInfoObject {\n\n/**\n * 接口调用成功的回调\n */\nsuccess: (result: _getSystemInfoSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getSystemInfoSuccessObject {\n\n/**\n * 手机型号\n */\nmodel: any,\n\n/**\n * 设备像素比\n */\npixelRatio: any,\n\n/**\n * 屏幕宽度\n */\nscreenWidth: any,\n\n/**\n * 屏幕高度\n */\nscreenHeight: any,\n\n/**\n * 可使用窗口宽度\n */\nwindowWidth: any,\n\n/**\n * 可使用窗口高度\n */\nwindowHeight: any,\n\n/**\n * 微信设置的语言\n */\nlanguage: any,\n\n/**\n * 微信版本号\n */\nversion: any,\n\n/**\n * 操作系统版本\n */\nsystem: any,\n\n/**\n * 客户端平台\n */\nplatform: any,\n\n/**\n * 客户端基础库版本\n */\nSDKVersion: any,\n\n}\n\ninterface _getStorageInfoObject {\n\n/**\n * 接口调用的回调函数，详见返回参数说明\n */\nsuccess: (result: _getStorageInfoSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getStorageInfoSuccessObject {\n\n/**\n * 当前storage中所有的key\n */\nkeys: any,\n\n/**\n * 当前占用的空间大小, 单位kb\n */\ncurrentSize: number,\n\n/**\n * 限制的空间大小，单位kb\n */\nlimitSize: number,\n\n}\n\ninterface _getStorageObject {\n\n/**\n * 本地缓存中的指定的 key\n */\nkey: string,\n\n/**\n * 接口调用的回调函数,res = {data: key对应的内容}\n */\nsuccess: (result: _getStorageSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getStorageSuccessObject {\n\n/**\n * key对应的内容\n */\ndata: string,\n\n}\n\ninterface _getShareInfoObject {\n\n/**\n * shareTicket\n */\nshareTicket: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _getShareInfoSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getShareInfoSuccessObject {\n\n/**\n * 错误信息\n */\nerrMsg: string,\n\n/**\n * 包括敏感数据在内的完整转发信息的加密数据，详细见[加密数据解密算法](./signature.md#加密数据解密算法)\n */\nencryptedData: string,\n\n/**\n * 加密算法的初始向量，详细见[加密数据解密算法](./signature.md#加密数据解密算法)\n */\niv: string,\n\n}\n\ninterface _getSettingObject {\n\n/**\n * 接口调用成功的回调函数，返回内容详见返回参数说明。\n */\nsuccess: (result: _getSettingSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getSettingSuccessObject {\n\n/**\n * 用户授权结果，其中 key 为 scope 值，value 为 Bool 值，表示用户是否允许授权，详见 [scope 列表](./authorize.md#scope-列表)\n */\nauthSetting: object,\n\n}\n\ninterface _getScreenBrightnessObject {\n\n/**\n * 接口调用成功\n */\nsuccess: (result: _getScreenBrightnessSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getScreenBrightnessSuccessObject {\n\n/**\n * 屏幕亮度值，范围 0~1，0 最暗，1 最亮\n */\nvalue: number,\n\n}\n\ninterface _getSavedFileListObject {\n\n/**\n * 接口调用成功的回调函数，返回结果见`success返回参数说明`\n */\nsuccess: (result: _getSavedFileListSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getSavedFileListSuccessObject {\n\n/**\n * 接口调用结果\n */\nerrMsg: string,\n\n/**\n * 文件列表\n */\nfileList: any,\n\n}\n\ninterface _getSavedFileInfoObject {\n\n/**\n * 文件路径\n */\nfilePath: string,\n\n/**\n * 接口调用成功的回调函数，返回结果见`success返回参数说明`\n */\nsuccess: (result: _getSavedFileInfoSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getSavedFileInfoSuccessObject {\n\n/**\n * 接口调用结果\n */\nerrMsg: string,\n\n/**\n * 文件大小，单位B\n */\nsize: number,\n\n/**\n * 文件的保存是的时间戳，从1970/01/01 08:00:00 到当前时间的秒数\n */\ncreateTime: number,\n\n}\n\ninterface _getNetworkTypeObject {\n\n/**\n * 接口调用成功，返回网络类型 networkType\n */\nsuccess: (result: _getNetworkTypeSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getNetworkTypeSuccessObject {\n\n/**\n * 网络类型\n */\nnetworkType: any,\n\n}\n\ninterface _getLocationObject {\n\n/**\n * 默认为 wgs84 返回 gps 坐标，gcj02 返回可用于`wx.openLocation`的坐标\n */\ntype: string,\n\n/**\n * 接口调用成功的回调函数，返回内容详见返回参数说明。\n */\nsuccess: (result: _getLocationSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getLocationSuccessObject {\n\n/**\n * 纬度，浮点数，范围为-90~90，负数表示南纬\n */\nlatitude: any,\n\n/**\n * 经度，浮点数，范围为-180~180，负数表示西经\n */\nlongitude: any,\n\n/**\n * 速度，浮点数，单位m/s\n */\nspeed: any,\n\n/**\n * 位置的精确度\n */\naccuracy: any,\n\n/**\n * 高度，单位 m\n */\naltitude: any,\n\n/**\n * 垂直精度，单位 m（Android 无法获取，返回 0）\n */\nverticalAccuracy: any,\n\n/**\n * 水平精度，单位 m\n */\nhorizontalAccuracy: any,\n\n}\n\ninterface _getImageInfoObject {\n\n/**\n * 图片的路径，可以是相对路径，临时文件路径，存储文件路径，网络图片路径\n */\nsrc: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _getImageInfoSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getImageInfoSuccessObject {\n\n/**\n * 图片宽度，单位px\n */\nwidth: number,\n\n/**\n * 图片高度 单位px\n */\nheight: number,\n\n/**\n * 返回图片的本地路径\n */\npath: string,\n\n}\n\ninterface _getFileInfoObject {\n\n/**\n * 本地文件路径\n */\nfilePath: string,\n\n/**\n * 计算文件摘要的算法，默认值 md5，有效值：md5，sha1\n */\ndigestAlgorithm: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _getFileInfoSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getFileInfoSuccessObject {\n\n/**\n * 文件大小，单位：B\n */\nsize: number,\n\n/**\n * 按照传入的 digestAlgorithm 计算得出的的文件摘要\n */\ndigest: string,\n\n/**\n * 调用结果\n */\nerrMsg: string,\n\n}\n\ninterface _getExtConfigSyncReturnValue {\n\n/**\n * 第三方平台自定义的数据\n */\nextConfig: object,\n\n}\n\ninterface _getExtConfigObject {\n\n/**\n * 返回第三方平台自定义的数据\n */\nsuccess: (result: _getExtConfigSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getExtConfigSuccessObject {\n\n/**\n * 调用结果\n */\nerrMsg: string,\n\n/**\n * 第三方平台自定义的数据\n */\nextConfig: object,\n\n}\n\ninterface _getConnectedBluetoothDevicesObject {\n\n/**\n * 蓝牙设备主 service 的 uuid 列表\n */\nservices: any,\n\n/**\n * 成功则返回本机蓝牙适配器状态\n */\nsuccess: (result: _getConnectedBluetoothDevicesSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getConnectedBluetoothDevicesSuccessObject {\n\n/**\n * 搜索到的设备列表\n */\ndevices: any,\n\n/**\n * 成功：ok，错误：详细信息\n */\nerrMsg: string,\n\n}\n\ninterface _getClipboardDataObject {\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _getClipboardDataSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getClipboardDataSuccessObject {\n\n/**\n * 剪贴板的内容\n */\ndata: string,\n\n}\n\ninterface _getBluetoothDevicesObject {\n\n/**\n * 成功则返回本机蓝牙适配器状态\n */\nsuccess: (result: _getBluetoothDevicesSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getBluetoothDevicesSuccessObject {\n\n/**\n * uuid 对应的的已连接设备列表\n */\ndevices: any,\n\n/**\n * 成功：ok，错误：详细信息\n */\nerrMsg: string,\n\n}\n\ninterface _getBluetoothAdapterStateObject {\n\n/**\n * 成功则返回本机蓝牙适配器状态\n */\nsuccess: (result: _getBluetoothAdapterStateSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getBluetoothAdapterStateSuccessObject {\n\n/**\n * 是否正在搜索设备\n */\ndiscovering: boolean,\n\n/**\n * 蓝牙适配器是否可用\n */\navailable: boolean,\n\n/**\n * 成功：ok，错误：详细信息\n */\nerrMsg: string,\n\n}\n\ninterface _getBeaconsObject {\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _getBeaconsSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getBeaconsSuccessObject {\n\n/**\n * iBeacon 设备列表\n */\nbeacons: any,\n\n/**\n * 调用结果\n */\nerrMsg: string,\n\n}\n\ninterface _getBackgroundAudioPlayerStateObject {\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _getBackgroundAudioPlayerStateSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getBackgroundAudioPlayerStateSuccessObject {\n\n/**\n * 选定音频的长度（单位：s），只有在当前有音乐播放时返回\n */\nduration: any,\n\n/**\n * 选定音频的播放位置（单位：s），只有在当前有音乐播放时返回\n */\ncurrentPosition: any,\n\n/**\n * 播放状态（2：没有音乐在播放，1：播放中，0：暂停中）\n */\nstatus: any,\n\n/**\n * 音频的下载进度（整数，80 代表 80%），只有在当前有音乐播放时返回\n */\ndownloadPercent: any,\n\n/**\n * 歌曲数据链接，只有在当前有音乐播放时返回\n */\ndataUrl: any,\n\n}\n\ninterface _getBackgroundAudioManagerReturnValue {\n\n/**\n * 当前音频的长度（单位：s），只有在当前有合法的 src 时返回\n */\nduration: number,\n\n/**\n * 当前音频的播放位置（单位：s），只有在当前有合法的 src 时返回\n */\ncurrentTime: number,\n\n/**\n * 当前是是否暂停或停止状态，true 表示暂停或停止，false 表示正在播放\n */\npaused: boolean,\n\n/**\n * 音频的数据源，默认为空字符串，**当设置了新的 src 时，会自动开始播放** ，目前支持的格式有 m4a, aac, mp3, wav\n */\nsrc: string,\n\n/**\n * 音频开始播放的位置（单位：s）\n */\nstartTime: number,\n\n/**\n * 音频缓冲的时间点，仅保证当前播放时间点到此时间点内容已缓冲。\n */\nbuffered: number,\n\n/**\n * 音频标题，用于做原生音频播放器音频标题。原生音频播放器中的分享功能，分享出去的卡片标题，也将使用该值。\n */\ntitle: string,\n\n/**\n * 专辑名，原生音频播放器中的分享功能，分享出去的卡片简介，也将使用该值。\n */\nepname: string,\n\n/**\n * 歌手名，原生音频播放器中的分享功能，分享出去的卡片简介，也将使用该值。\n */\nsinger: string,\n\n/**\n * 封面图url，用于做原生音频播放器背景图。原生音频播放器中的分享功能，分享出去的卡片配图及背景也将使用该图。\n */\ncoverImgUrl: string,\n\n/**\n * 页面链接，原生音频播放器中的分享功能，分享出去的卡片简介，也将使用该值。\n */\nwebUrl: string,\n\n/**\n * 播放\n */\nplay: () => void,\n\n\n/**\n * 暂停\n */\npause: () => void,\n\n\n/**\n * 停止\n */\nstop: () => void,\n\n\n/**\n * 跳转到指定位置，单位 s\n */\nseek: () => void,\n\n\n/**\n * 背景音频进入可以播放状态，但不保证后面可以流畅播放\n */\nonCanplay: () => void,\n\n\n/**\n * 背景音频播放事件\n */\nonPlay: () => void,\n\n\n/**\n * 背景音频暂停事件\n */\nonPause: () => void,\n\n\n/**\n * 背景音频停止事件\n */\nonStop: () => void,\n\n\n/**\n * 背景音频自然播放结束事件\n */\nonEnded: () => void,\n\n\n/**\n * 背景音频播放进度更新事件\n */\nonTimeUpdate: () => void,\n\n\n/**\n * 用户在系统音乐播放面板点击上一曲事件（iOS only）\n */\nonPrev: () => void,\n\n\n/**\n * 用户在系统音乐播放面板点击下一曲事件（iOS only）\n */\nonNext: () => void,\n\n\n/**\n * 背景音频播放错误事件\n */\nonError: () => void,\n\n\n/**\n * 音频加载中事件，当音频因为数据不足，需要停下来加载时会触发\n */\nonWaiting: () => void,\n\n\n}\n\ninterface _getBLEDeviceServicesObject {\n\n/**\n * 蓝牙设备 id，参考 getDevices 接口\n */\ndeviceId: string,\n\n/**\n * 成功则返回本机蓝牙适配器状态\n */\nsuccess: (result: _getBLEDeviceServicesSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getBLEDeviceServicesSuccessObject {\n\n/**\n * 设备服务列表\n */\nservices: any,\n\n/**\n * 成功：ok，错误：详细信息\n */\nerrMsg: string,\n\n}\n\ninterface _getBLEDeviceCharacteristicsObject {\n\n/**\n * 蓝牙设备 id，参考 device 对象\n */\ndeviceId: string,\n\n/**\n * 蓝牙服务 uuid\n */\nserviceId: string,\n\n/**\n * 成功则返回本机蓝牙适配器状态\n */\nsuccess: (result: _getBLEDeviceCharacteristicsSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _getBLEDeviceCharacteristicsSuccessObject {\n\n/**\n * 设备特征值列表\n */\ncharacteristics: any,\n\n/**\n * 成功：ok，错误：详细信息\n */\nerrMsg: string,\n\n}\n\ninterface _downloadFileObject {\n\n/**\n * undefined\n */\nurl: string,\n\n/**\n * undefined\n */\nheader: object,\n\n/**\n * undefined\n */\nsuccess: () => void,\n\n\n/**\n * undefined\n */\nfail: () => void,\n\n\n/**\n * undefined\n */\ncomplete: () => void,\n\n\n}\ninterface _createBLEConnectionObject {\n\n/**\n * 蓝牙设备 id，参考 getDevices 接口\n */\ndeviceId: string,\n\n/**\n * 成功则返回本机蓝牙适配器状态\n */\nsuccess: (result: _createBLEConnectionSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _createBLEConnectionSuccessObject {\n\n/**\n * 成功：ok，错误：详细信息\n */\nerrMsg: string,\n\n}\n\ninterface _createAnimationObject {\n\n/**\n * 动画持续时间，单位ms\n */\nduration: any,\n\n/**\n * 定义动画的效果\n */\ntimingFunction: string,\n\n/**\n * 动画延迟时间，单位 ms\n */\ndelay: any,\n\n/**\n * 设置transform-origin\n */\ntransformOrigin: string,\n\n}\ninterface _connectSocketObject {\n\n/**\n * 开发者服务器接口地址，必须是 wss 协议，且域名必须是后台配置的合法域名\n */\nurl: string,\n\n/**\n * 请求的数据\n */\ndata: object,\n\n/**\n * HTTP Header , header 中不能设置 Referer\n */\nheader: object,\n\n/**\n * 默认是GET，有效值： OPTIONS, GET, HEAD, POST, PUT, DELETE, TRACE, CONNECT\n */\nmethod: string,\n\n/**\n * 子协议数组\n */\nprotocols: any,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _closeSocketObject {\n\n/**\n * 一个数字值表示关闭连接的状态号，表示连接被关闭的原因。如果这个参数没有被指定，默认的取值是1000 （表示正常连接关闭）\n */\ncode: number,\n\n/**\n * 一个可读的字符串，表示连接被关闭的原因。这个字符串必须是不长于123字节的UTF-8 文本（不是字符）\n */\nreason: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _closeBluetoothAdapterObject {\n\n/**\n * 成功则返回成功关闭模块信息\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _closeBLEConnectionObject {\n\n/**\n * 蓝牙设备 id，参考 getDevices 接口\n */\ndeviceId: string,\n\n/**\n * 成功则返回本机蓝牙适配器状态\n */\nsuccess: (result: _closeBLEConnectionSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _closeBLEConnectionSuccessObject {\n\n/**\n * 成功：ok，错误：详细信息\n */\nerrMsg: string,\n\n}\n\ninterface _chooseVideoObject {\n\n/**\n * album 从相册选视频，camera 使用相机拍摄，默认为：['album', 'camera']\n */\nsourceType: any,\n\n/**\n * 拍摄视频最长拍摄时间，单位秒。最长支持 60 秒\n */\nmaxDuration: number,\n\n/**\n * 默认调起的为前置还是后置摄像头。front: 前置，back: 后置，默认 back\n */\ncamera: string,\n\n/**\n * 接口调用成功，返回视频文件的临时文件路径，详见返回参数说明\n */\nsuccess: (result: _chooseVideoSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _chooseVideoSuccessObject {\n\n/**\n * 选定视频的临时文件路径\n */\ntempFilePath: any,\n\n/**\n * 选定视频的时间长度\n */\nduration: any,\n\n/**\n * 选定视频的数据量大小\n */\nsize: any,\n\n/**\n * 返回选定视频的长\n */\nheight: any,\n\n/**\n * 返回选定视频的宽\n */\nwidth: any,\n\n}\n\ninterface _chooseLocationObject {\n\n/**\n * 接口调用成功的回调函数，返回内容详见返回参数说明。\n */\nsuccess: (result: _chooseLocationSuccessObject,) => void,\n\n\n/**\n * 用户取消时调用\n */\ncancel: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _chooseLocationSuccessObject {\n\n/**\n * 位置名称\n */\nname: any,\n\n/**\n * 详细地址\n */\naddress: any,\n\n/**\n * 纬度，浮点数，范围为-90~90，负数表示南纬\n */\nlatitude: any,\n\n/**\n * 经度，浮点数，范围为-180~180，负数表示西经\n */\nlongitude: any,\n\n}\n\ninterface _chooseImageObject {\n\n/**\n * 最多可以选择的图片张数，默认9\n */\ncount: number,\n\n/**\n * original 原图，compressed 压缩图，默认二者都有\n */\nsizeType: any,\n\n/**\n * album 从相册选图，camera 使用相机，默认二者都有\n */\nsourceType: any,\n\n/**\n * 成功则返回图片的本地文件路径列表 tempFilePaths\n */\nsuccess: (result: _chooseImageSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _chooseImageSuccessObject {\n\n/**\n * 图片的本地文件路径列表\n */\ntempFilePaths: any,\n\n/**\n * 图片的本地文件列表，每一项是一个 File 对象\n */\ntempFiles: any,\n\n}\n\ninterface _chooseContactObject {\n\n/**\n * 返回用户选择的联系人信息\n */\nsuccess: (result: _chooseContactSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _chooseContactSuccessObject {\n\n/**\n * 电话号码\n */\nphoneNumber: any,\n\n/**\n * 联系人名称\n */\ndisplayName: any,\n\n}\n\ninterface _chooseAddressObject {\n\n/**\n * 返回用户选择的收货地址信息\n */\nsuccess: (result: _chooseAddressSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _chooseAddressSuccessObject {\n\n/**\n * 调用结果\n */\nerrMsg: string,\n\n/**\n * 收货人姓名\n */\nuserName: string,\n\n/**\n * 邮编\n */\npostalCode: string,\n\n/**\n * 国标收货地址第一级地址\n */\nprovinceName: string,\n\n/**\n * 国标收货地址第二级地址\n */\ncityName: string,\n\n/**\n * 国标收货地址第三级地址\n */\ncountyName: string,\n\n/**\n * 详细收货地址信息\n */\ndetailInfo: string,\n\n/**\n * 收货地址国家码\n */\nnationalCode: string,\n\n/**\n * 收货人手机号码\n */\ntelNumber: string,\n\n}\n\ninterface _checkSessionObject {\n\n/**\n * 接口调用成功的回调函数，登录态未过期\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数，登录态已过期\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _captureScreenObject {\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _captureScreenSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _captureScreenSuccessObject {\n\n/**\n * 截屏产生图片的本地文件路径\n */\ntempFilePath: string,\n\n/**\n * 调用结果\n */\nerrMsg: string,\n\n}\n\ninterface _canvasToTempFilePathObject {\n\n/**\n * 画布x轴起点（默认0）\n */\nx: number,\n\n/**\n * 画布y轴起点（默认0）\n */\ny: number,\n\n/**\n * 画布宽度（默认为canvas宽度-x）\n */\nwidth: number,\n\n/**\n * 画布高度（默认为canvas高度-y）\n */\nheight: number,\n\n/**\n * 输出图片宽度（默认为width）\n */\ndestWidth: number,\n\n/**\n * 输出图片高度（默认为height）\n */\ndestHeight: number,\n\n/**\n * 画布标识，传入 [`<canvas/>`](../../component/canvas.md) 的 cavas-id\n */\ncanvasId: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _authorizeObject {\n\n/**\n * 需要获取权限的scope，详见 [scope 列表](./authorize.md#scope-列表)\n */\nscope: string,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _authorizeSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _authorizeSuccessObject {\n\n/**\n * 调用结果\n */\nerrMsg: string,\n\n}\n\ninterface _addPhoneContactObject {\n\n/**\n * 头像本地文件路径\n */\nphotoFilePath: string,\n\n/**\n * 昵称\n */\nnickName: string,\n\n/**\n * 姓氏\n */\nlastName: string,\n\n/**\n * 中间名\n */\nmiddleName: string,\n\n/**\n * 名字\n */\nfirstName: string,\n\n/**\n * 备注\n */\nremark: string,\n\n/**\n * 手机号\n */\nmobilePhoneNumber: string,\n\n/**\n * 微信号\n */\nweChatNumber: string,\n\n/**\n * 联系地址国家\n */\naddressCountry: string,\n\n/**\n * 联系地址省份\n */\naddressState: string,\n\n/**\n * 联系地址城市\n */\naddressCity: string,\n\n/**\n * 联系地址街道\n */\naddressStreet: string,\n\n/**\n * 联系地址邮政编码\n */\naddressPostalCode: string,\n\n/**\n * 公司\n */\norganization: string,\n\n/**\n * 职位\n */\ntitle: string,\n\n/**\n * 工作传真\n */\nworkFaxNumber: string,\n\n/**\n * 工作电话\n */\nworkPhoneNumber: string,\n\n/**\n * 公司电话\n */\nhostNumber: string,\n\n/**\n * 电子邮件\n */\nemail: string,\n\n/**\n * 网站\n */\nurl: string,\n\n/**\n * 工作地址国家\n */\nworkAddressCountry: string,\n\n/**\n * 工作地址省份\n */\nworkAddressState: string,\n\n/**\n * 工作地址城市\n */\nworkAddressCity: string,\n\n/**\n * 工作地址街道\n */\nworkAddressStreet: string,\n\n/**\n * 工作地址邮政编码\n */\nworkAddressPostalCode: string,\n\n/**\n * 住宅传真\n */\nhomeFaxNumber: string,\n\n/**\n * 住宅电话\n */\nhomePhoneNumber: string,\n\n/**\n * 住宅地址国家\n */\nhomeAddressCountry: string,\n\n/**\n * 住宅地址省份\n */\nhomeAddressState: string,\n\n/**\n * 住宅地址城市\n */\nhomeAddressCity: string,\n\n/**\n * 住宅地址街道\n */\nhomeAddressStreet: string,\n\n/**\n * 住宅地址邮政编码\n */\nhomeAddressPostalCode: string,\n\n/**\n * 接口调用成功\n */\nsuccess: () => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _addCardObject {\n\n/**\n * 需要添加的卡券列表，列表内对象说明请参见[请求对象说明](#请求对象说明)\n */\ncardList: any,\n\n/**\n * 接口调用成功的回调函数\n */\nsuccess: (result: _addCardSuccessObject,) => void,\n\n\n/**\n * 接口调用失败的回调函数\n */\nfail: () => void,\n\n\n/**\n * 接口调用结束的回调函数（调用成功、失败都会执行）\n */\ncomplete: () => void,\n\n\n}\ninterface _addCardSuccessObject {\n\n/**\n * 卡券添加结果列表，列表内对象说明请详见[返回对象说明](#返回对象说明)\n */\ncardList: any,\n\n}\n\ninterface _ShareAppMessageReturnObject {\n\n  /**\n   * 分享标题。默认为当前小程序名称。\n   */  \n  title: string;\n  \n  /**\n   * 分享路径。默认为当前页面 path，必须是以 / 开头的完整路径。\n   */  \n  path: string;  \n  \n}\n\ninterface _AppShowOptions {\n  /**\n   * 打开小程序的路径\n   */\n  path: string,\n   \n  /**\n   * 打开小程序的query\n   */\n  query: object,\n  \n  /**\n   * 打开小程序的场景值\n   */\n  scene: number,\n  \n  /**\n   * shareTicket\n   */\n  shareTicket: string\n}\n\n\ndeclare interface _AppOptions {\n\n  /**\n   * 当小程序初始化完成时，会触发 onLaunch（全局只触发一次）\n   */\n  onLaunch?: (options: _AppShowOptions) => void;\n\n  /**\n   * 当小程序启动，或从后台进入前台显示，会触发 onShow\n   */\n  onShow?: (options: _AppShowOptions) => void;\n\n  /**\n   * 当小程序从前台进入后台，会触发 onHide\n   */\n  onHide?: () => void;\n\n  /**\n   * 当小程序发生脚本错误，或者 api 调用失败时，会触发 onError 并带上错误信息\n   */\n  onError?: (msg: string) => void;\n}\n\ndeclare function App(options: _AppOptions): void;\n\n/**\n * 获取到小程序实例\n */\ndeclare function getApp(): object;\n\n\ndeclare interface PageOptions {\n\n  /**\n   * 页面的初始数据\n   */\n  data?: any;\n\n  /**\n   * 生命周期函数--监听页面加载\n   */\n  onLoad?: (options?: object) => void;\n\n  /**\n   * 生命周期函数--监听页面初次渲染完成\n   */  \n  onReady?: () => void;\n\n  /**\n   * 生命周期函数--监听页面显示\n   */  \n  onShow?: () => void;\n\n  /**\n   * 生命周期函数--监听页面隐藏\n   */  \n  onHide?: () => void;\n\n  /**\n   * 生命周期函数--监听页面卸载\n   */  \n  onUnload?: () => void;\n\n  /**\n   * 页面相关事件处理函数--监听用户下拉动作\n   */  \n  onPullDownRefresh?: () => void;\n\n  /**\n   * 页面上拉触底事件的处理函数\n   */  \n  onReachBottom?: () => void;\n\n  /**\n   * 用户点击右上角分享\n   */  \n  onShareAppMessage?: () => _ShareAppMessageReturnObject;\n\n  /**\n   * 页面上拉触底事件的处理函数\n   */  \n  onReachBottom?: () => void;\n  \n  /**\n   * 页面相关事件处理函数--监听用户下拉动作\n   */  \n  onPullDownRefresh?: () => void;\n}\n\ndeclare function Page(page: PageOptions): void;\n\ndeclare function getCurrentPages(): object[];\n\ndeclare namespace wx {\n/**\n * 批量添加卡券。\n */\nexport function addCard(object: _addCardObject,): void\n\n/**\n * 调用后，用户可以选择将该表单以“新增联系人”或“添加到已有联系人”的方式，写入手机系统通讯录，完成手机通讯录联系人和联系方式的增加。\n */\nexport function addPhoneContact(object: _addPhoneContactObject,): void\n\n\n/**\n * 将 ArrayBuffer 数据转成 Base64 字符串\n */\nexport function arrayBufferToBase64(): void\n\n/**\n * 部分接口需要获得同意后才能调用。此类接口调用时，如果用户未授权过，会弹窗询问用户，用户点击同意后方可调用接口。如果用户点了拒绝，则短期内调用不会出现弹窗，而是直接进入 fail 回调。用户可以在小程序设置界面中修改对该小程序的授权信息。本接口用于提前向用户发起授权，调用后会立刻弹窗询问用户是否同意小程序使用某项功能或获取用户的某些数据，但不会实际调用接口。如果用户之前已经同意，则不会出现弹窗，直接返回成功。\n */\nexport function authorize(object: _authorizeObject,): void\n\n/**\n * 将 Base64 字符串转成 ArrayBuffer 数据\n */\nexport function base64ToArrayBuffer(base64: string,): void\n\n/**\n * 判断小程序的API，回调，参数，组件等是否在当前版本可用。\n */\nexport function canIUse(string: string,): void\n\n/**\n * 把当前画布指定区域的内容导出生成指定大小的图片，并返回文件路径。\n */\nexport function canvasToTempFilePath(object: _canvasToTempFilePathObject,): void\n\n\n/**\n * 截取当前屏幕内容\n */\nexport function captureScreen(object: _captureScreenObject,): void\n\n/**\n * 通过上述接口获得的用户登录态拥有一定的时效性。用户越久未使用小程序，用户登录态越有可能失效。反之如果用户一直在使用小程序，则用户登录态一直保持有效。具体时效逻辑由微信维护，对开发者透明。开发者只需要调用wx.checkSession接口**检测当前用户登录态是否有效**。登录态过期后开发者可以再调用wx.login获取新的用户登录态。\n */\nexport function checkSession(object: _checkSessionObject,): void\n\n\n/**\n * 调起用户编辑收货地址原生界面，并在编辑完成后返回用户选择的地址。\n */\nexport function chooseAddress(object: _chooseAddressObject,): void\n\n/**\n * 调起选择手机通讯录联系人界面，返回用户选择的联系人信息。\n */\nexport function chooseContact(object: _chooseContactObject,): void\n\n/**\n * 从本地相册选择图片或使用相机拍照。\n */\nexport function chooseImage(object: _chooseImageObject,): void\n\n/**\n * 打开地图选择位置\n */\nexport function chooseLocation(object: _chooseLocationObject,): void\n\n/**\n * 拍摄视频或从手机相册中选视频，返回视频的临时文件路径。\n */\nexport function chooseVideo(object: _chooseVideoObject,): void\n\n/**\n * 清理本地数据缓存。\n */\nexport function clearStorage(): void\n\n/**\n * 同步清理本地数据缓存\n */\nexport function clearStorageSync(): void\n\n/**\n * 断开与低功耗蓝牙设备的连接\n */\nexport function closeBLEConnection(object: _closeBLEConnectionObject,): void\n\n/**\n * 关闭蓝牙模块。调用该方法将断开所有已建立的链接并释放系统资源\n */\nexport function closeBluetoothAdapter(object: _closeBluetoothAdapterObject,): void\n\n\n/**\n * 关闭WebSocket连接。\n */\nexport function closeSocket(object: _closeSocketObject,): void\n\n\n/**\n * 创建一个 [WebSocket](https://developer.mozilla.org/zh-CN/docs/Web/API/WebSocket) 连接；**一个微信小程序同时只能有一个 WebSocket 连接，如果当前已存在一个 WebSocket 连接，会自动关闭该连接，并重新创建一个 WebSocket 连接。**\n */\nexport function connectSocket(object: _connectSocketObject,): void\n\n\n/**\n * 创建一个动画实例[animation](#animation)。调用实例的方法来描述动画。最后通过动画实例的`export`方法导出动画数据传递给组件的`animation`属性。\n */\nexport function createAnimation(object: _createAnimationObject,): void\n\n\n/**\n * 创建并返回 audio 上下文 `audioContext` 对象\n */\nexport function createAudioContext(audioid: string,): void\n\n/**\n * 连接低功耗蓝牙设备\n */\nexport function createBLEConnection(object: _createBLEConnectionObject,): void\n\n/**\n * 创建 canvas 绘图上下文（指定 canvasId）\n */\nexport function createCanvasContext(canvasid: string,): CanvasContext\n\n/**\n * 创建并返回绘图上下文。\n */\nexport function createContext(): CanvasContext\n\n/**\n * 创建并返回 map 上下文 `mapContext` 对象\n */\nexport function createMapContext(mapid: string,): void\n\n/**\n * undefined\n */\nexport function createSelectorQuery(): void\n\n/**\n * 创建并返回 video 上下文 `videoContext` 对象\r\n */\nexport function createVideoContext(videoid: string,): void\n\n/**\n * 下载文件资源到本地。客户端直接发起一个 HTTP GET 请求，返回文件的本地临时路径。\n */\nexport function downloadFile(object: _downloadFileObject,): void\n\n\n/**\n * 蓝牙设备characteristic(特征值)信息\n */\nexport function getBLEDeviceCharacteristics(object: _getBLEDeviceCharacteristicsObject,): void\n\n/**\n * 获取蓝牙设备所有 service（服务）\n */\nexport function getBLEDeviceServices(object: _getBLEDeviceServicesObject,): void\n\n/**\n * 获取**全局唯一**的背景音频管理器 `backgroundAudioManager`\n */\nexport function getBackgroundAudioManager(): _getBackgroundAudioManagerReturnValue\n\n/**\n * 获取后台音乐播放状态。\n */\nexport function getBackgroundAudioPlayerState(object: _getBackgroundAudioPlayerStateObject,): void\n\n/**\n * 获取所有已搜索到的`iBeacon`设备\n */\nexport function getBeacons(object: _getBeaconsObject,): void\n\n/**\n * 获取本机蓝牙适配器状态\n */\nexport function getBluetoothAdapterState(object: _getBluetoothAdapterStateObject,): void\n\n/**\n * 获取所有已发现的蓝牙设备，包括已经和本机处于连接状态的设备\n */\nexport function getBluetoothDevices(object: _getBluetoothDevicesObject,): void\n\n/**\n * 获取系统剪贴板内容\n */\nexport function getClipboardData(object: _getClipboardDataObject,): void\n\n/**\n * 根据 uuid 获取处于已连接状态的设备\n */\nexport function getConnectedBluetoothDevices(object: _getConnectedBluetoothDevicesObject,): void\n\n/**\n * 获取第三方平台自定义的数据字段。\r\n */\nexport function getExtConfig(object: _getExtConfigObject,): void\n\n/**\n * 获取第三方平台自定义的数据字段的同步接口。\r\n */\nexport function getExtConfigSync(): _getExtConfigSyncReturnValue\n\n/**\n * 获取文件信息\n */\nexport function getFileInfo(object: _getFileInfoObject,): void\n\n/**\n * 获取图片信息\n */\nexport function getImageInfo(object: _getImageInfoObject,): void\n\n/**\n * 获取当前的地理位置、速度。当用户离开小程序后，此接口无法调用；当用户点击“显示在聊天顶部”时，此接口可继续调用。\n */\nexport function getLocation(object: _getLocationObject,): void\n\n/**\n * 获取网络类型。\n */\nexport function getNetworkType(object: _getNetworkTypeObject,): void\n\n/**\n * 获取本地文件的文件信息。此接口只能用于获取已保存到本地的文件，若需要获取临时文件信息，请使用 [wx.getFileInfo](./getFileInfo.md) 接口。\n */\nexport function getSavedFileInfo(object: _getSavedFileInfoObject,): void\n\n/**\n * 获取本地已保存的文件列表\n */\nexport function getSavedFileList(object: _getSavedFileListObject,): void\n\n/**\n * 获取屏幕亮度。\n */\nexport function getScreenBrightness(object: _getScreenBrightnessObject,): void\n\n/**\n * 获取用户的当前设置\n */\nexport function getSetting(object: _getSettingObject,): void\n\n/**\n * 获取转发详细信息\n */\nexport function getShareInfo(object: _getShareInfoObject,): void\n\n/**\n * 从本地缓存中异步获取指定 key 对应的内容。\n */\nexport function getStorage(object: _getStorageObject,): void\n\n/**\n * 异步获取当前storage的相关信息\n */\nexport function getStorageInfo(object: _getStorageInfoObject,): void\n\n/**\n * 同步获取当前storage的相关信息\n */\nexport function getStorageInfoSync(): void\n\n/**\n * 从本地缓存中同步获取指定 key 对应的内容。\n */\nexport function getStorageSync(key: string,): void\n\n/**\n * 获取系统信息。\n */\nexport function getSystemInfo(object: _getSystemInfoObject,): void\n\n/**\n * 获取系统信息同步接口\n */\nexport function getSystemInfoSync(): _getSystemInfoSyncReturnValue\n\n/**\n * 获取用户信息，需要先调用 [wx.login](./api-login.md#wxloginobject) 接口。\n */\nexport function getUserInfo(object: _getUserInfoObject,): void\n\n/**\n * 获取用户过去三十天微信运动步数，需要先调用 [wx.login](./api-login.md#wxloginobject) 接口。\n */\nexport function getWeRunData(object: _getWeRunDataObject,): void\n\n/**\n * 隐藏 loading 提示框\n */\nexport function hideLoading(): void\n\n/**\n * 隐藏导航条加载动画。\n */\nexport function hideNavigationBarLoading(): void\n\n/**\n * 隐藏转发按钮\n */\nexport function hideShareMenu(object: _hideShareMenuObject,): void\n\n\n/**\n * 隐藏消息提示框\n */\nexport function hideToast(): void\n\n/**\n * 调用接口获取**登录凭证（code）**进而换取用户登录态信息，包括用户的**唯一标识（openid）** 及本次登录的 **会话密钥（session_key）**。**用户数据的加解密通讯**需要依赖会话密钥完成。\n */\nexport function login(object: _loginObject,): void\n\n/**\n * wx.makePhoneCall({\n */\nexport function makePhoneCall(object: _makePhoneCallObject,): void\n\n\n/**\n * 关闭当前页面，返回上一页面或多级页面。可通过 [`getCurrentPages()`](../framework/app-service/page.md#getCurrentPages()) 获取当前的页面栈，决定需要返回几层。\n */\nexport function navigateBack(object: _navigateBackObject,): void\n\n\n/**\n * 返回到上一个小程序，只有在当前小程序是被其他小程序打开时可以调用成功\n */\nexport function navigateBackMiniProgram(object: _navigateBackMiniProgramObject,): void\n\n/**\n * 保留当前页面，跳转到应用内的某个页面，使用`wx.navigateBack`可以返回到原页面。\n */\nexport function navigateTo(object: _navigateToObject,): void\n\n\n/**\n * 打开同一公众号下关联的另一个小程序。\n */\nexport function navigateToMiniProgram(object: _navigateToMiniProgramObject,): void\n\n/**\n * 启用低功耗蓝牙设备特征值变化时的 notify 功能。注意：必须设备的特征值支持`notify`才可以成功调用，具体参照 characteristic 的 properties 属性\n */\nexport function notifyBLECharacteristicValueChange(object: _notifyBLECharacteristicValueChangeObject,): void\n\n/**\n * 监听加速度数据，频率：5次/秒，接口调用后会自动开始监听，可使用 `wx.stopAccelerometer` 停止监听。\n */\nexport function onAccelerometerChange(callback: (result: _onAccelerometerChangeCallbackResult) => void,): void\n\n\n/**\n * 监听低功耗蓝牙设备的特征值变化。必须先启用`notify`接口才能接收到设备推送的notification。\n */\nexport function onBLECharacteristicValueChange(callback: (result: _onBLECharacteristicValueChangeCallbackResult) => void,): void\n\n\n/**\n * 监听低功耗蓝牙连接的错误事件，包括设备丢失，连接异常断开等等。\n */\nexport function onBLEConnectionStateChange(callback: (result: _onBLEConnectionStateChangeCallbackResult) => void,): void\n\n\n/**\n * 监听音乐暂停。\n */\nexport function onBackgroundAudioPause(callback: string,): void\n\n/**\n * 监听音乐播放。\n */\nexport function onBackgroundAudioPlay(callback: string,): void\n\n/**\n * 监听音乐停止。\n */\nexport function onBackgroundAudioStop(callback: string,): void\n\n/**\n * 监听 `iBeacon` 服务的状态变化\n */\nexport function onBeaconServiceChange(callback: (result: _onBeaconServiceChangeCallbackResult) => void,): void\n\n\n/**\n * 监听 `iBeacon` 设备的更新事件\n */\nexport function onBeaconUpdate(callback: (result: _onBeaconUpdateCallbackResult) => void,): void\n\n\n/**\n * 监听蓝牙适配器状态变化事件\n */\nexport function onBluetoothAdapterStateChange(callback: (result: _onBluetoothAdapterStateChangeCallbackResult) => void,): void\n\n\n/**\n * 监听寻找到新设备的事件\n */\nexport function onBluetoothDeviceFound(callback: (result: _onBluetoothDeviceFoundCallbackResult) => void,): void\n\n\n/**\n * 监听罗盘数据，频率：5次/秒，接口调用后会自动开始监听，可使用`wx.stopCompass`停止监听。\n */\nexport function onCompassChange(callback: (result: _onCompassChangeCallbackResult) => void,): void\n\n\n/**\n * 监听网络状态变化。\n */\nexport function onNetworkStatusChange(callback: (result: _onNetworkStatusChangeCallbackResult) => void,): void\n\n\n/**\n * 监听WebSocket关闭。\n */\nexport function onSocketClose(callback: string,): void\n\n/**\n * 监听WebSocket错误。\n */\nexport function onSocketError(callback: string,): void\n\n/**\n * 监听WebSocket接受到服务器的消息事件。\n */\nexport function onSocketMessage(callback: (result: _onSocketMessageCallbackResult) => void,): void\n\n\n/**\n * 监听WebSocket连接打开事件。\n */\nexport function onSocketOpen(callback: string,): void\n\n/**\n * 监听用户主动截屏事件，用户使用系统截屏按键截屏时触发此事件\n */\nexport function onUserCaptureScreen(callback: (result: _onUserCaptureScreenCallbackResult) => void,): void\n\n\n/**\n * 初始化蓝牙适配器\n */\nexport function openBluetoothAdapter(object: _openBluetoothAdapterObject,): void\n\n\n/**\n * 查看微信卡包中的卡券。\n */\nexport function openCard(object: _openCardObject,): void\n\n\n/**\n * 新开页面打开文档，支持格式：doc, xls, ppt, pdf, docx, xlsx, pptx\n */\nexport function openDocument(object: _openDocumentObject,): void\n\n\n/**\n * ​\t使用微信内置地图查看位置\n */\nexport function openLocation(object: _openLocationObject,): void\n\n\n/**\n * 调起客户端小程序设置界面，返回用户设置的操作结果\n */\nexport function openSetting(object: _openSettingObject,): void\n\n/**\n * 将页面滚动到目标位置。\n */\nexport function pageScrollTo(object: _pageScrollToObject,): void\n\n\n/**\n * 暂停播放音乐。\n */\nexport function pauseBackgroundAudio(): void\n\n/**\n * 暂停正在播放的语音。再次调用wx.playVoice播放同一个文件时，会从暂停处开始播放。如果想从头开始播放，需要先调用 wx.stopVoice。\n */\nexport function pauseVoice(): void\n\n/**\n * 使用后台播放器播放音乐，对于微信客户端来说，只能同时有一个后台音乐在播放。当用户离开小程序后，音乐将暂停播放；当用户点击“显示在聊天顶部”时，音乐不会暂停播放；当用户在其他小程序占用了音乐播放器，原有小程序内的音乐将停止播放。\n */\nexport function playBackgroundAudio(object: _playBackgroundAudioObject,): void\n\n\n/**\n * 开始播放语音，同时只允许一个语音文件正在播放，如果前一个语音文件还没播放完，将中断前一个语音播放。\n */\nexport function playVoice(object: _playVoiceObject,): void\n\n\n/**\n * 预览图片。\n */\nexport function previewImage(object: _previewImageObject,): void\n\n\n/**\n * 关闭所有页面，打开到应用内的某个页面。\n */\nexport function reLaunch(object: _reLaunchObject,): void\n\n\n/**\n * 读取低功耗蓝牙设备的特征值的二进制数据值。注意：必须设备的特征值支持`read`才可以成功调用，具体参照 characteristic 的 properties 属性\n */\nexport function readBLECharacteristicValue(object: _readBLECharacteristicValueObject,): void\n\n/**\n * 关闭当前页面，跳转到应用内的某个页面。\n */\nexport function redirectTo(object: _redirectToObject,): void\n\n\n/**\n * 删除本地存储的文件\n */\nexport function removeSavedFile(object: _removeSavedFileObject,): void\n\n\n/**\n * 从本地缓存中异步移除指定 key 。\n */\nexport function removeStorage(object: _removeStorageObject,): void\n\n\n/**\n * 从本地缓存中同步移除指定 key 。\n */\nexport function removeStorageSync(key: string,): void\n\n/**\n * 自定义分析数据上报接口。使用前，需要在小程序管理后台自定义分析中新建事件，配置好事件名与字段。\n */\nexport function reportAnalytics(eventname: string,data: string,): void\n\n/**\n * 最终发送给服务器的数据是 String 类型，如果传入的 data 不是 String 类型，会被转换成 String 。转换规则如下：\n */\nexport function request(object: _requestObject,): void\n\n/**\n * 发起微信支付。\n */\nexport function requestPayment(object: _requestPaymentObject,): void\n\n\n/**\n * 保存文件到本地。\n */\nexport function saveFile(object: _saveFileObject,): void\n\n/**\n * 保存图片到系统相册，需要用户授权（scope.writePhotosAlbum），详见 [用户授权](./authorize.md#wxauthorizeobject)\n */\nexport function saveImageToPhotosAlbum(object: _saveImageToPhotosAlbumObject,): void\n\n/**\n * 保存视频到系统相册，需要用户授权（scope.writePhotosAlbum），详见 [用户授权](./authorize.md#wxauthorizeobject)\n */\nexport function saveVideoToPhotosAlbum(object: _saveVideoToPhotosAlbumObject,): void\n\n/**\n * 调起客户端扫码界面，扫码成功后返回对应的结果\n */\nexport function scanCode(object: _scanCodeObject,): void\n\n/**\n * 控制音乐播放进度。\n */\nexport function seekBackgroundAudio(object: _seekBackgroundAudioObject,): void\n\n\n/**\n * 通过 WebSocket 连接发送数据，需要先 [wx.connectSocket](#wxconnectsocketobject)，并在 [wx.onSocketOpen](#wxonsocketopencallback) 回调之后才能发送。\n */\nexport function sendSocketMessage(object: _sendSocketMessageObject,): void\n\n\n/**\n * 设置系统剪贴板的内容\n */\nexport function setClipboardData(object: _setClipboardDataObject,): void\n\n\n/**\n * 设置是否打开调试开关，此开关对正式版也能生效。\n */\nexport function setEnableDebug(object: _setEnableDebugObject,): void\n\n/**\n * 设置是否保持常亮状态。仅在当前小程序生效，离开小程序后设置失效。\n */\nexport function setKeepScreenOn(object: _setKeepScreenOnObject,): void\n\n/**\n * wx.setNavigationBarColor({\n */\nexport function setNavigationBarColor(object: _setNavigationBarColorObject,): void\n\n/**\n * 动态设置当前页面的标题。\n */\nexport function setNavigationBarTitle(object: _setNavigationBarTitleObject,): void\n\n\n/**\n * 设置屏幕亮度。\n */\nexport function setScreenBrightness(object: _setScreenBrightnessObject,): void\n\n\n/**\n * 将数据存储在本地缓存中指定的 key 中，会覆盖掉原来该 key 对应的内容，这是一个异步接口。\n */\nexport function setStorage(object: _setStorageObject,): void\n\n\n/**\n * 将 data 存储在本地缓存中指定的 key 中，会覆盖掉原来该 key 对应的内容，这是一个同步接口。\n */\nexport function setStorageSync(key: string,): void\n\n/**\n * ​显示操作菜单\n */\nexport function showActionSheet(object: _showActionSheetObject,): void\n\n/**\n * 显示 loading 提示框, 需主动调用 [wx.hideLoading](#wxhideloading) 才能关闭提示框\n */\nexport function showLoading(object: _showLoadingObject,): void\n\n\n/**\n * ​显示模态弹窗\n */\nexport function showModal(object: _showModalObject,): void\n\n/**\n * 在当前页面显示导航条加载动画。\n */\nexport function showNavigationBarLoading(): void\n\n/**\n * 显示当前页面的转发按钮\n */\nexport function showShareMenu(object: _showShareMenuObject,): void\n\n\n/**\n * 显示消息提示框\n */\nexport function showToast(object: _showToastObject,): void\n\n\n/**\n * 开始监听加速度数据。\n */\nexport function startAccelerometer(object: _startAccelerometerObject,): void\n\n\n/**\n * 开始搜索附近的`iBeacon`设备\n */\nexport function startBeaconDiscovery(object: _startBeaconDiscoveryObject,): void\n\n/**\n * 开始搜寻附近的蓝牙外围设备。注意，该操作比较耗费系统资源，请在搜索并连接到设备后调用 stop 方法停止搜索。\n */\nexport function startBluetoothDevicesDiscovery(object: _startBluetoothDevicesDiscoveryObject,): void\n\n/**\n * 开始监听罗盘数据。\n */\nexport function startCompass(object: _startCompassObject,): void\n\n\n/**\n * 开始录音。当主动调用`wx.stopRecord`，或者录音超过1分钟时自动结束录音，返回录音文件的临时文件路径。当用户离开小程序时，此接口无法调用。\n */\nexport function startRecord(object: _startRecordObject,): void\n\n/**\n * 停止监听加速度数据。\n */\nexport function stopAccelerometer(object: _stopAccelerometerObject,): void\n\n\n/**\n * 停止播放音乐。\n */\nexport function stopBackgroundAudio(): void\n\n/**\n * 停止搜索附近的`iBeacon`设备\n */\nexport function stopBeaconDiscovery(object: _stopBeaconDiscoveryObject,): void\n\n/**\n * 停止搜寻附近的蓝牙外围设备。请在确保找到需要连接的设备后调用该方法停止搜索。\n */\nexport function stopBluetoothDevicesDiscovery(object: _stopBluetoothDevicesDiscoveryObject,): void\n\n/**\n * 停止监听罗盘数据。\n */\nexport function stopCompass(object: _stopCompassObject,): void\n\n\n/**\n * 停止当前页面下拉刷新。\n */\nexport function stopPullDownRefresh(): void\n\n/**\n * ​\t主动调用停止录音。\n */\nexport function stopRecord(): void\n\n/**\n * 结束播放语音。\n */\nexport function stopVoice(): void\n\n/**\n * 跳转到 tabBar 页面，并关闭其他所有非 tabBar 页面\n */\nexport function switchTab(object: _switchTabObject,): void\n\n\n/**\n * 更新转发属性\n */\nexport function updateShareMenu(object: _updateShareMenuObject,): void\n\n\n/**\n * 将本地资源上传到开发者服务器。如页面通过 [wx.chooseImage](./media-picture.md#wxchooseimageobject) 等接口获取到一个本地资源的临时文件路径后，可通过此接口将本地资源上传到指定服务器。客户端发起一个 HTTPS POST 请求，其中 `content-type` 为 `multipart/form-data` 。\n */\nexport function uploadFile(object: _uploadFileObject,): void\n\n/**\n * 使手机发生较长时间的振动（400ms）\n */\nexport function vibrateLong(object: _vibrateLongObject,): void\n\n\n/**\n * 使手机发生较短时间的振动（15ms）\n */\nexport function vibrateShort(object: _vibrateShortObject,): void\n\n\n/**\n * 向低功耗蓝牙设备特征值中写入二进制数据。注意：必须设备的特征值支持`write`才可以成功调用，具体参照 characteristic 的 properties 属性\n */\nexport function writeBLECharacteristicValue(object: _writeBLECharacteristicValueObject,): void\n\n}"