const BASE_URL = 'https://api.sxl.cn'
export default {
  REQUESTS: {
    // post.js
    GET_POST: productId =>
      `${BASE_URL}/r/v1/blog_posts/${productId}?v=${new Date().getTime()}`,
    GET_POSTS: (siteId, category, pageNum = 1) =>
      category === 'all'
        ? `${BASE_URL}/r/v1/sites/${siteId}/mini_program/blog?limit=8&page=${pageNum}&expand=blogPosts&exclude_content=true&v=${new Date().getTime()}`
        : `${BASE_URL}/r/v1/sites/${siteId}/mini_program/blog?expand=blogPosts&limit=8&page=${pageNum}&tag=${encodeURI(
            `${category}`
          )}&exclude_content=true&v=${new Date().getTime()}`,
    GET_POSTS_SEARCH: siteId =>
      `${BASE_URL}/r/v1/mini_program/apps/${siteId}/search_blog_posts?v=${new Date().getTime()}`,
    // category
    GET_CATEGORIES: pageId =>
      `${BASE_URL}/r/v1/sites/${pageId}/blog/tags?v=${new Date().getTime()}`,
    // comment
    GET_COMMENTS: (postId, pageNum) =>
      `${BASE_URL}/r/v1/mini_program/blog/blog_posts/${postId}/user_comments?per=9999&page=${pageNum}`,
    SET_COMMENTS: postId =>
      `${BASE_URL}/r/v1/mini_program/blog/blog_posts/${postId}/user_comments`,
    // sharing
    GET_SHARING_BASICINFO: siteId =>
      `${BASE_URL}/r/v1/sites/${siteId}/mp/basic_info`,
    SET_SHARING_SCENECODE: siteId =>
      `${BASE_URL}/r/v1/sites/${siteId}/mp/scene_codes`,
    // setting
    GET_SETTINGS: pageId =>
      `${BASE_URL}/r/v1/sites/${pageId}/blog_settings?v=${new Date().getTime()}`,
    SET_LIKE_POST: postId =>
      `${BASE_URL}/r/v1/mini_program/blog/blog_posts/${postId}/likes`,
    DELETE_LIKE_POST: postId =>
      `${BASE_URL}/r/v1/mini_program/blog/likes/${postId}`
  },
  METHODS: {
    // post
    GET_POSTS: () => 'GET',
    GET_POST: () => 'GET',
    GET_POSTS_SEARCH: () => 'POST',
    // category
    GET_CATEGORIES: () => 'GET',
    // comment
    GET_COMMENTS: () => 'GET',
    SET_COMMENTS: () => 'POST',
    // setting
    GET_SETTINGS: () => 'GET',
    // sharing
    GET_SHARING_BASICINFO: () => 'GET',
    SET_SHARING_SCENECODE: () => 'POST'
  },
  PAGES: {
    POST_INDEX: '/pages/postIndex/postIndex',
    POST_DETAIL: '/pages/postDetail/postDetail',
    POST_LIST: '/pages/postList/postList',
    POST_SEARCH: '/pages/postSearch/postSearch',
    MORE: '/pages/more/more',
    ABOUT: '/pages/about/about',
    SXL: '/pages/sxl/sxl',
    POST_SHARE: '/pages/postShare/postShare',
    WMP_SHARE: '/pages/wmpShare/wmpShare'
  },
  NAVIGATION: {
    POST_INDEX: 'pages#blog#more#more',
    ABOUT: 'pages#blog#about#about'
  }
}
