const component = {
  properties: {
    shortcuts: { type: Array, value: [] },
    shortcutsFirstLine: { type: Array, value: [] },
    shortcutsSecondLine: { type: Array, value: [] },
    shortcutsSecondLineWrapperClass: { type: String, value: '' },
    showContactBtn: { type: Boolean, value: false }
  },
  methods: {
    handlePost(e) {
      const { id } = e.currentTarget.dataset
      var detail = {
        postId: id
      }
      this.triggerEvent('PostTap', detail)
    },
    handleCategory(e) {
      const { id, name } = e.currentTarget.dataset
      const detail = {
        id,
        name
      }
      this.triggerEvent('CategoryTap', detail)
    },
    handlePage(e) {
      const { id } = e.currentTarget.dataset
      const detail = { url: id }
      this.triggerEvent('PageTap', detail)
    },
    makePhoneCall(e) {
      const { phone = '' } = e.currentTarget.dataset
      wx.makePhoneCall({
        phoneNumber: phone
      })
    }
  }
}

Component(component)
