export default {
  REQUESTS: {
    // post.js
    GET_POST: (code, productId) =>
      `/r/v1/blog_posts/${productId}?code=${code}&v=${new Date().getTime()}`,
    GET_POSTS: (siteId, code, category, pageNum = 1) => category === 'all'
        ? `/r/v1/sites/${siteId}/mini_program/blog?limit=8&page=${pageNum}&code=${code}&expand=blogPosts&exclude_content=true&v=${new Date().getTime()}`
        : `/r/v1/sites/${siteId}/mini_program/blog?expand=blogPosts&limit=8&page=${pageNum}&tag=${encodeURI(`${category}`)}&code=${code}&exclude_content=true&v=${new Date().getTime()}`,
    GET_POSTS_SEARCH: siteId =>
      `/r/v1/mini_program/apps/${siteId}/search_blog_posts?v=${new Date().getTime()}`,
    // category
    GET_CATEGORIES: pageId =>
      `/r/v1/sites/${pageId}/blog/tags?v=${new Date().getTime()}`,
    // comment
    GET_COMMENTS: (postId, pageNum) =>
      `/r/v1/mini_program/blog/blog_posts/${postId}/user_comments?per=9999&page=${pageNum}`,
    SET_COMMENTS: postId =>
      `/r/v1/mini_program/blog/blog_posts/${postId}/user_comments`,
    // sharing
    GET_SHARING_BASICINFO: siteId => `/r/v1/sites/${siteId}/mp/basic_info`,
    SET_SHARING_SCENECODE: siteId => `/r/v1/sites/${siteId}/mp/scene_codes`,
    // setting
    GET_SETTINGS: pageId =>
      `/r/v1/sites/${pageId}/blog_settings?v=${new Date().getTime()}`,
    SET_LIKE_POST: postId => `/r/v1/mini_program/blog/blog_posts/${postId}/likes`,
    DELETE_LIKE_POST: postId => `/r/v1/mini_program/blog/likes/${postId}`
  },
  METHODS: {
    // post
    GET_POSTS: () => 'GET',
    GET_POST: () => 'GET',
    GET_POSTS_SEARCH: () => 'POST',
    // category
    GET_CATEGORIES: () => 'GET',
    // comment
    GET_COMMENTS: () => 'GET',
    SET_COMMENTS: () => 'POST',
    // setting
    GET_SETTINGS: () => 'GET',
    // sharing
    GET_SHARING_BASICINFO: () => 'GET',
    SET_SHARING_SCENECODE: () => 'POST',
  },
  PAGES: {
    POST_INDEX: '/pages/blog/postIndex/postIndex',
    POST_DETAIL: '/pages/blog/postDetail/postDetail',
    POST_LIST: '/pages/blog/postList/postList',
    POST_SEARCH: '/pages/blog/postSearch/postSearch',
    MORE: '/pages/blog/more/more',
    ABOUT: '/pages/blog/about/about',
    SXL: '/pages/blog/sxl/sxl',
    POST_SHARE: '/pages/blog/postShare/postShare',
    WMP_SHARE: '/pages/blog/wmpShare/wmpShare',
  },
  NAVIGATION: {
    POST_INDEX: 'pages#blog#more#more',
    ABOUT: 'pages#blog#about#about',
  },
}
