/**
 * This middleware can only work in wmp
 * @returns {undefined}
 */

export function errorModalMiddleware({ getState }) {
  return next => action => {
    next(action)

    const state = getState()
    const { message } = state.getIn(['error']).toJS()
    if (message) {
      wx.showModal({
        content: message,
        showCancel: false,
      })
    }
  }
}
