const resetItem = (item, typeMap) => {
  item.label = item.label ? item.label : ''
  if (item.label.match(/【.*】/)) {
    item.label = item.label.match(/【.*】/)[0].replace(/【|】/g, '')
  }
  let path = item.subtype
  if (item.type === 'ui' && item.subtype === 'sharePage') {
    try {
      const pathParam = JSON.parse(item.extraParam)
      path = pathParam.path
      for (const key in typeMap) {
        const regEx = new RegExp(key)
        if (regEx.test(path)) {
          if (typeMap[key].isShare) {
            return Object.assign(
              {},
              item,
              { isHiddenRadar: false },
              typeMap[key],
            )
          } else {
            return Object.assign(
              {},
              item,
              { isHiddenRadar: true },
              typeMap[key],
            )
          }
        }
      }
    } catch (err) {
      throw new Error('pathParam parse error')
    }
  }
  for (const key in typeMap) {
    const regEx = new RegExp(key)
    if (regEx.test(path)) {
      return Object.assign(
        {},
        item,
        {
          isHiddenRadar: false,
          isStayTime: typeMap[key].isStayTime,
        },
        typeMap[key],
      )
    }
  }
  return Object.assign({}, item, {
    name: item.label,
    isHiddenRadar: true,
  })
}
export const formatRadar = item => {
  // fix label value is null or `点赞了 【博客】`
  item.label = item.label ? item.label : ''
  const radarUiTypeShow = [
    'chat',
    'leaveContact',
    'submitContactForm',
    'likeBlogPost',
    'likeContactCard',
    'shareContactCard',
    'sharePostPage',
    'shareProductPage',
    'shareImageBlogPost',
    'shareImageProduct',
    'saveAsImage',
    'saveToContact',
    'copyWechatId',
    'viewQrcode',
    'copyEmail',
    'enterApp',
    'leaveApp',
  ]
  if (item.label.match(/【.*】/)) {
    item.label = item.label.match(/【.*】/)[0].replace(/【|】/g, '')
  }
  const radarPvTypeShow = {
    'productDetail/productDetail': {
      pageName: '产品',
      name: `【${item.label}】`,
      highLight: true,
      showTimes: true,
      isShare: true,
      isStayTime: true,
    },
    'product/product': {
      pageName: '产品分类',
      name: `【${item.label}】`,
      highLight: true,
      showTimes: true,
    },
    'postList/postList': {
      pageName: '文章分类',
      name: `【${item.label}】`,
      highLight: true,
      showTimes: true,
    },
    'postDetail/postDetail': {
      pageName: '文章',
      name: `【${item.label}】`,
      highLight: true,
      showTimes: true,
      isShare: true,
      isStayTime: true,
    },
    'presentation/index/index': {
      pageName: '',
      name: `首页`,
      highLight: true,
      showTimes: true,
      isShare: false,
    },
    'contact/contact': {
      isShare: true,
      pageName: '您的',
      name: `名片`,
      highLight: true,
      showTimes: true,
      isHiddenRadar: true,
    },
  }

  // fix the pv include blog's and product's catgary and detail
  if (item.type === 'pv') {
    item = resetItem(item, radarPvTypeShow)
  } else if (item.type === 'ui') {
    if (radarUiTypeShow.indexOf(item.subtype) > -1) {
      item.name = `【${item.label}】`
      item.isHiddenRadar = false
    } else if (item.subtype === 'sharePage') {
      item = resetItem(item, radarPvTypeShow)
    } else {
      item.isHiddenRadar = true
    }
  }
  // the personalized push text
  if (item.subtype === 'chat') {
    item.welcomeText = item.repeatTimes >= 2 ? '' : '快去回复吧'
  } else if (item.subtype === 'submitContactForm') {
    item.welcomeText = item.repeatTimes >= 2 ? '' : '快去看看他说了什么吧'
  } else if (item.subtype === 'likeContactCard') {
    item.welcomeText = item.repeatTimes >= 2 ? '' : '似乎对您有好感，快联系ta吧'
  } else if (item.subtype === 'viewContactCard') {
    item.showTimes = true
    item.welcomeText =
      item.repeatTimes >= 2 ? '看来成交在望，快联系ta吧!' : '初识在此刻'
  } else if (item.subtype === 'shareContactCard') {
    item.showTimes = true
    item.welcomeText =
      item.repeatTimes >= 2
        ? '看来成交在望，快联系ta吧！'
        : '您的人脉正在扩散！'
  } else if (item.subtype === 'saveAsImage') {
    item.welcomeText =
      item.repeatTimes >= 2 ? '' : '近期可能会联系您，密切关注哦'
  } else if (item.subtype === 'copyWechatId') {
    item.welcomeText = item.repeatTimes >= 2 ? '' : '可能会加您好友，请留意哦'
  } else if (item.subtype === 'shareImageProduct') {
    item.welcomeText =
      item.repeatTimes >= 2
        ? '看来成交在望，快联系ta吧'
        : '看来还挺感兴趣的，快联系ta吧'
  } else if (item.subtype === 'copyEmail') {
    item.welcomeText =
      item.repeatTimes >= 2 ? '' : '可能会发送邮件给您，请留意哦'
  } else if (item.subtype === 'sharePage') {
    let path
    try {
      const pathParam = JSON.parse(item.extraParam)
      path = pathParam.path
    } catch (err) {
      throw new Error('pathParam parse error')
    }
    if (path.includes('contact/contact')) {
      item.welcomeText =
        item.repeatTimes >= 2
          ? '看来成交在望，快联系ta吧！'
          : '您的人脉正在扩散！'
    }
  } else if (item.subtype === 'likeBlogPost') {
    item.welcomeText = item.repeatTimes >= 2 ? '' : '看来很认可呢，要不要联系下'
  } else if (item.type === 'pv') {
    if (item.subtype.includes('postList?category')) {
      item.welcomeText =
        item.repeatTimes >= 2
          ? '看来成交在望，快联系ta吧'
          : '看来对这类文章还挺感兴趣的，快联系ta介绍更多吧'
    } else if (item.subtype.includes('product?category')) {
      item.welcomeText =
        item.repeatTimes >= 2
          ? '看来成交在望，快联系ta吧'
          : '看来对这类产品还挺感兴趣的，快联系ta介绍更多吧'
    } else if (item.subtype.includes('postId')) {
      item.welcomeText =
        item.repeatTimes >= 2
          ? '看来成交在望，快联系ta吧'
          : '看来对公司还挺感兴趣的，快联系ta吧'
    } else if (item.subtype.includes('productId')) {
      item.welcomeText =
        item.repeatTimes >= 2
          ? '看来成交在望，快联系ta吧'
          : '看来还挺感兴趣的，快联系ta吧'
    } else if (item.subtype.includes('presentation/index/index')) {
      item.isStayTime = true
      item.welcomeText =
        item.repeatTimes >= 2
          ? '看来对公司还挺感兴趣的，快联系ta吧'
          : '这是个重要情报哦'
    } else if (item.subtype.includes('contact/contact')) {
      item.isStayTime = true
      item.welcomeText =
        item.repeatTimes >= 2 ? '看来成交在望，快联系ta吧' : '初识在此刻'
    } else if (item.subtype.includes('businessCard/businessCard')) {
      item.highLight = false
      item.pageName = '您的'
      item.name = '名片夹'
      item.showTimes = true
    }
  }
  if (item.subtype === 'leaveContact') {
    const str1 = item.label.split('，')[0]
    const str2 = str1.split('留下了电话：')
    item.phone = str2[1]
    item.name = str2[0]
    item.nickname = str2[0]
  }

  if (item.subtype === 'shareProductPage') {
    item.welcomeText =
      item.repeatTimes >= 2
        ? '看来成交在望，快联系ta吧！'
        : '看来还挺感兴趣的，快联系ta吧'
  }
  if (item.subtype === 'sharePostPage') {
    item.welcomeText =
      item.repeatTimes >= 2
        ? '看来成交在望，快联系ta吧！'
        : '看来还挺感兴趣的，快联系ta吧'
  }

  const hourTime = parseInt(item.dwellTime / 3600)
    ? `${parseInt(item.dwellTime / 3600)}小时`
    : ``
  const minuteTime = parseInt((item.dwellTime % 3600) / 60)
    ? `${parseInt((item.dwellTime % 3600) / 60)}分钟`
    : ``
  const secondTime = `${
    (item.dwellTime % 3600) % 60 && item.type === 'pv'
      ? (item.dwellTime % 3600) % 60
      : (item.dwellTime % 3600) % 60 + 1
  }秒`
  item.dwellTime = hourTime + minuteTime + secondTime

  return item
}
