import wrappedWXTool from 'wechat_common/utils/wrappedWXTool'
import { setGlobalData } from 'root/reducers/ecommerce/global'
import { dispatch } from 'root/wmp-redux'

export default function login(cb) {
  wrappedWXTool.login({
    success(loginRes) {
      const { code } = loginRes
      dispatch(
        setGlobalData({
          code,
        }),
      )

      if (cb && typeof cb === 'function') {
        cb(loginRes)
      }

      wrappedWXTool.wxGetuserInfo().then(getInfoRes => {
        dispatch(
          setGlobalData({
            userInfo: getInfoRes.userInfo,
          }),
        )
      })
    },
  })
}
