import { iconPath } from 'root/constants/presentation/iconPath'
import {
  getRoundImage,
  replaceWithDownloadFileDomain,
} from 'root/utils/helpers/presentationHelper'
import { showModal } from 'wechat_common/utils/wrappedWXTool'

export const getScoreText = score => {
  const map = {
    1: '很差',
    2: '不太满意',
    3: '一般',
    4: '比较满意',
    5: '非常满意',
  }
  return map[score]
}

const getImageInfo = url =>
  new Promise((resolve, reject) => {
    wx.getImageInfo({
      src: url,
      success: res => {
        resolve(res)
      },
      fail: e => {
        reject(e)
      },
    })
  })

const rpxToPx = size => {
  const { windowWidth } = wx.getSystemInfoSync()
  return windowWidth * size / 750
}

function drawCloseIcon() {
  const ctx = wx.createCanvasContext('closeIcon')
  ctx.setFillStyle('#ffffff')
  ctx.drawImage(
    iconPath.ICON_CANVAS_CLOSE,
    rpxToPx(710) - rpxToPx(104),
    15,
    30,
    30,
  )
  ctx.draw()
}

export const drawContactCard = (
  teamMember,
  logoUrl,
  isWhiteBackground,
  companyName,
) =>
  new Promise((resolve, reject) => {
    const ctx = wx.createCanvasContext('contactCard')
    const { profile } = teamMember

    // bg
    ctx.setFillStyle('#ffffff')
    ctx.fillRect(0, 0, rpxToPx(710), rpxToPx(950))

    const { avatarUrl, roundAvatarUrl } = profile
    const qrCodeUrl = teamMember.qrCode
    const imageUrlList = [qrCodeUrl, roundAvatarUrl]
    const promiseList = imageUrlList.map(url => getImageInfo(url))
    Promise.all(promiseList)
      .catch(() => {
        showModal({
          content: '图片加载失败，请稍后重试',
          showCancel: false,
        })
        reject()
      })
      .then(([verifyQrCodeInfo, roundAvatarInfo]) => {
        const verifyQrCodePath = verifyQrCodeInfo.path
        const roundAvatarPath = roundAvatarInfo.path
        const cardOrigin = {
          x: rpxToPx(43),
          y: rpxToPx(220),
        }
        const avatarData = {
          w: rpxToPx(200),
          h: rpxToPx(200),
          r: rpxToPx(100), // 头像半径
        }

        const drawImage = (imagePath, beginX, beginY, width, height) => {
          ctx.drawImage(imagePath, beginX, beginY, width, height)
        }

        // 画用户头像
        drawImage(roundAvatarPath, 20, 30, avatarData.w, avatarData.h)
        // 画用户信息
        drawProfile()

        // 画下方二维码
        drawBottomBar()

        ctx.draw()
        resolve()

        function drawProfile() {
          const profileOrigin = {
            m: rpxToPx(353), // 中点
            l: rpxToPx(43), // 左起点
            r: rpxToPx(650), // 右终点
            y: rpxToPx(300), // 高度起点
          }
          const iconData = {
            w: rpxToPx(36),
            h: rpxToPx(36),
          }

          drawProfileBackground()

          ctx.setFontSize(rpxToPx(30))
          drawPhone()
          if (profile.wechatAccount) {
            drawWechatAccount()
          }
          if (profile.email) {
            drawEmail()
          }

          function drawProfileBackground() {
            // name
            ctx.setFontSize(rpxToPx(40))
            ctx.setFillStyle('#000000')
            ctx.fillText(profile.name, 140, 70)

            drawPosition()
            if (companyName) {
              drawCompany()
            }
          }
          function drawPosition() {
            // position 职位背景，icon，职位名称
            ctx.setFontSize(rpxToPx(30))
            const positionMetrics = ctx.measureText(profile.position).width
            ctx.setFillStyle(
              profile.color !== '#ffffff' ? profile.color : '#F4F4F4',
            )
            ctx.fillRect(140, 82, positionMetrics + 8, 24)
            // position
            ctx.setFillStyle(
              profile.color === '#ffffff' ? '#000000' : '#ffffff',
            )
            ctx.fillText(profile.position, 144, 100)
          }
          function drawCompany() {
            // company
            ctx.setFillStyle('#000000')
            const companyMetrics = ctx.measureText(companyName).width
            ctx.fillText(companyName, 22, profileOrigin.y + rpxToPx(22))
            // icon
            drawImage(
              iconPath.ICON_VERIFY,
              companyMetrics + 24,
              profileOrigin.y - 2,
              15,
              15,
            )
          }
          function drawPhone() {
            ctx.drawImage(
              iconPath.ICON_CANVAS_PHONE,
              profileOrigin.l,
              profileOrigin.y + rpxToPx(158) - rpxToPx(20),
              iconData.w,
              iconData.h,
            )
            ctx.setFillStyle('#999999')
            ctx.fillText(
              '手机',
              profileOrigin.l + iconData.w + rpxToPx(10),
              profileOrigin.y + rpxToPx(165),
            )
            const phoneMetrics = ctx.measureText(profile.phone).width
            ctx.setFillStyle('#666666')
            ctx.fillText(
              profile.phone,
              profileOrigin.r - phoneMetrics,
              profileOrigin.y + rpxToPx(165),
            )
            ctx.setStrokeStyle('#e8e8e8')
            ctx.setLineWidth(0.5)
            ctx.moveTo(profileOrigin.l, profileOrigin.y + rpxToPx(190))
            ctx.lineTo(profileOrigin.r, profileOrigin.y + rpxToPx(190))
            ctx.stroke()
          }

          function drawWechatAccount() {
            ctx.drawImage(
              iconPath.ICON_CANVAS_WECHAT,
              profileOrigin.l,
              profileOrigin.y + rpxToPx(82) - rpxToPx(20),
              iconData.w,
              iconData.h,
            )
            ctx.setFillStyle('#999999')
            ctx.fillText(
              '微信',
              profileOrigin.l + iconData.w + rpxToPx(10),
              profileOrigin.y + rpxToPx(89),
            )
            const wechatMetrics = ctx.measureText(profile.wechatAccount).width
            ctx.setFillStyle('#666666')
            ctx.fillText(
              profile.wechatAccount,
              profileOrigin.r - wechatMetrics,
              profileOrigin.y + rpxToPx(89),
            )
            ctx.setStrokeStyle('#e8e8e8')
            ctx.setLineWidth(0.5)
            ctx.moveTo(profileOrigin.l, profileOrigin.y + rpxToPx(116))
            ctx.lineTo(profileOrigin.r, profileOrigin.y + rpxToPx(116))
            ctx.stroke()
          }

          function drawEmail() {
            ctx.drawImage(
              iconPath.ICON_CANVAS_EMAIL,
              profileOrigin.l,
              profileOrigin.y + rpxToPx(230) - rpxToPx(20),
              iconData.w,
              iconData.h,
            )
            ctx.setFillStyle('#999999')
            ctx.fillText(
              '邮箱',
              profileOrigin.l + iconData.w + rpxToPx(10),
              profileOrigin.y + rpxToPx(237),
            )
            const emailMetrics = ctx.measureText(profile.email).width
            ctx.setFillStyle('#666666')
            ctx.fillText(
              profile.email,
              profileOrigin.r - emailMetrics,
              profileOrigin.y + rpxToPx(237),
            )
          }
        }

        function drawBottomBar() {
          ctx.setFontSize(rpxToPx(32))
          ctx.setFillStyle('#636972')
          ctx.fillText('长按识别二维码', rpxToPx(67), rpxToPx(689))
          ctx.fillText('进入小程序了解更多', rpxToPx(67), rpxToPx(744))

          ctx.drawImage(
            verifyQrCodePath,
            rpxToPx(416),
            rpxToPx(590),
            rpxToPx(219),
            rpxToPx(219),
          )

          ctx.drawImage(
            roundAvatarPath,
            rpxToPx(416) + rpxToPx(64),
            rpxToPx(590) + rpxToPx(64),
            rpxToPx(92),
            rpxToPx(92),
          )
        }

        drawCloseIcon()
      })
      .catch(() => {
        showModal({
          content: '图片渲染失败',
          showCancel: false,
        })
        reject()
      })
  })
