import { PAGES } from 'root/constants/admintool/urlConstants'

export function handleRequestSuccess() {
  wx.hideLoading()
}

export function handleRequestError(err) {
  wx.hideLoading()
  if (err.data.code === 200000) {
    wx.showModal({
      title: '身份验证失败',
      content: '请重新登录',
      showCancel: false,
      success: () => {
        wx.setStorageSync('admin_tool_token', null)
        wx.reLaunch({
          url: PAGES.LOGIN,
        })
      },
    })
  } else if (err.data.code === 200001) {
    wx.showModal({
      title: '手机号不存在',
      content: '请确认您输入的手机号已在员工授权管理中录入',
      showCancel: false,
      success: () => {
        wx.setStorageSync('admin_tool_token', null)
        wx.reLaunch({
          url: PAGES.LOGIN,
        })
      },
    })
  } else if (err.data.code === 200002) {
    wx.showModal({
      title: '重新登录',
      content: '权限发生变更，已被强行登出。请重新登录，或联系管理员。',
      showCancel: false,
      success: () => {
        wx.setStorageSync('admin_tool_token', null)
        wx.reLaunch({
          url: PAGES.LOGIN,
        })
      },
    })
  } else {
    wx.showModal({
      title: '获取失败',
      content: '请重新获取',
      showCancel: false,
    })
  }
}
