import { dispatch } from 'root/wmp-redux'
import { fetchSettings } from 'root/reducers/ecommerce/settings'
import {
  fetchProducts,
  fetchFlashSaleProducts,
  fetchGroupBuyProducts,
} from 'root/actions/ecommerce/productActions'
import { forceUpdate } from 'root/reducers/ecommerce/global'
import { getMembershipCard } from 'root/actions/ecommerce/membership/cardActions'

export function refreshData(siteId, code, doNotFetchProducts) {
  if (!doNotFetchProducts) {
    dispatch(fetchProducts(siteId, 'all', 1))
  }
  dispatch(fetchFlashSaleProducts('all', 1))
  code && dispatch(fetchGroupBuyProducts('all', 1, code))
  dispatch(fetchSettings(siteId))
  dispatch(getMembershipCard())
}
