import EmojiObj from './emojimap'

const emoji = EmojiObj.emojiList.emoji
const prefix = EmojiObj.emojiSxlUrl

/* eslint-disable max-statements */
function generateRichTextNode(text) {
  let tempStr = text
  const richTextNode = []
  let leftBracketIndex = tempStr.indexOf('[')
  let rightBracketIndex = 0

  // 没有emoji
  if (leftBracketIndex === -1) {
    richTextNode.push({
      type: 'text',
      text: tempStr,
    })
    return richTextNode
  }

  while (tempStr.length !== 0) {
    // 最前面是文本
    if (leftBracketIndex !== 0) {
      // 最后全是文字
      if (leftBracketIndex === -1) {
        richTextNode.push({
          type: 'text',
          text: tempStr.slice(0, tempStr.length),
        })
        tempStr = ''
      } else {
        richTextNode.push({
          type: 'text',
          text: tempStr.slice(0, leftBracketIndex),
        })
        tempStr = tempStr.substring(leftBracketIndex, tempStr.length + 1)
      }
    } else {
      // 前面是[
      rightBracketIndex = tempStr.indexOf(']')
      const emojiName = tempStr.slice(0, rightBracketIndex + 1)
      if (emoji[emojiName]) {
        richTextNode.push({
          name: 'img',
          attrs: {
            width: '20rpx',
            height: '20rpx',
            src: emoji[emojiName].img,
          },
        })
      } else {
        richTextNode.push({
          type: 'text',
          text: `${emojiName}`,
        })
      }
      tempStr = tempStr.substring(rightBracketIndex + 1, tempStr.length)
    }
    leftBracketIndex = tempStr.indexOf('[')
    if (tempStr.indexOf(']') === -1) {
      leftBracketIndex = -1
    }
  }
  return richTextNode
}
/* eslint-enable max-statements */

function generateImageNode(fileStr) {
  let file = {}
  try {
    file = JSON.parse(fileStr)
  } catch (e) {
    console.info('JSON parse error')
  }
  let width = 0
  let height = 0
  if (file.w > 150) {
    width = 100
    height = file.h / (file.w / 100)
  } else {
    width = file.w
    height = file.h
  }
  const richTextNode = []
  richTextNode.push({
    name: 'img',
    attrs: {
      width: `${width}rpx`,
      height: `${height}rpx`,
      src: file.url,
    },
  })
  return richTextNode
}

function generateBigEmojiImageFile(messageStr) {
  let content = {}
  try {
    content = JSON.parse(messageStr)
  } catch (e) {
    console.info('JSON parse error')
  }
  const file = { w: content.w, h: content.h, url: '' }
  file.url = `${prefix}/${content.catalog}/${content.name}`
  return JSON.stringify(file)
}

export const convertChatItem = item => {
  if (item.messageType === 'welcome_message') {
    return {
      ...item,
      customMessage: item.customMessageChanged
        ? item.customMessageChanged
        : JSON.parse(item.customMessage),
      messageType: 'welcome_message',
    }
  } else if (item.messageType === 'service_notification') {
    return {
      ...item,
      messageType: 'service_notification',
    }
  }

  if (item.message) {
    return {
      ...item,
      messageType: 'text',
      nodes: generateRichTextNode(item.message),
    }
  } else if (item.messageType === 'image') {
    return {
      ...item,
      messageType: 'image',
      nodes: generateImageNode(item.customMessage),
    }
  } else if (item.messageType === 'big_emoji') {
    return {
      ...item,
      messageType: 'image',
      nodes: generateImageNode(generateBigEmojiImageFile(item.customMessage)),
    }
  } else {
    return {
      ...item,
      messageType: 'text',
    }
  }
}
