import { doGet, doPost, doPut, doDelete } from 'wechat_common/utils/request'
import { bindSiteId, bindCode } from 'wechat_common/utils/context'
import Urls from 'root/constants/blog/urls'
import compose from 'ramda/src/compose'
import {
  bindRetry,
  bindShowToast,
} from 'wechat_common/networkErrorManager'

const getPostDetail = compose(bindCode, bindSiteId)(
  (siteId, code, { params: { postId }, ...options }) =>
    doGet(
      bindRetry({
        url: Urls.REQUESTS.GET_POST(code, postId),
        ...options,
      }),
    ),
)

const getPosts = compose(bindCode, bindSiteId)(
  (siteId, code, { params: { category, pageNum }, ...options }) =>
    doGet(
      bindRetry({
        url: Urls.REQUESTS.GET_POSTS(siteId, code, category, pageNum),
        ...options,
      }),
    ),
)

const likePost = compose(bindCode, bindSiteId)(
  (
    siteId,
    code,
    { params: { status, postId, nickname, wechat_photo }, ...options },
  ) => {
    const params = {
      url: status
        ? Urls.REQUESTS.SET_LIKE_POST(postId)
        : Urls.REQUESTS.DELETE_LIKE_POST(postId),
      data: { code, nickname, wechat_photo },
      ...options,
    }
    if (status) {
      doPost(bindShowToast(params))
    } else {
      doDelete(bindShowToast(params))
    }
  },
)

export default {
  likePost,
  getPosts,
  getPostDetail,
}
